﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/ssm/SSM_EXPORTS.h>
#include <aws/ssm/model/MaintenanceWindowExecutionStatus.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SSM {
namespace Model {
class GetMaintenanceWindowExecutionResult {
 public:
  AWS_SSM_API GetMaintenanceWindowExecutionResult() = default;
  AWS_SSM_API GetMaintenanceWindowExecutionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SSM_API GetMaintenanceWindowExecutionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ID of the maintenance window execution.</p>
   */
  inline const Aws::String& GetWindowExecutionId() const { return m_windowExecutionId; }
  template <typename WindowExecutionIdT = Aws::String>
  void SetWindowExecutionId(WindowExecutionIdT&& value) {
    m_windowExecutionIdHasBeenSet = true;
    m_windowExecutionId = std::forward<WindowExecutionIdT>(value);
  }
  template <typename WindowExecutionIdT = Aws::String>
  GetMaintenanceWindowExecutionResult& WithWindowExecutionId(WindowExecutionIdT&& value) {
    SetWindowExecutionId(std::forward<WindowExecutionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the task executions from the maintenance window execution.</p>
   */
  inline const Aws::Vector<Aws::String>& GetTaskIds() const { return m_taskIds; }
  template <typename TaskIdsT = Aws::Vector<Aws::String>>
  void SetTaskIds(TaskIdsT&& value) {
    m_taskIdsHasBeenSet = true;
    m_taskIds = std::forward<TaskIdsT>(value);
  }
  template <typename TaskIdsT = Aws::Vector<Aws::String>>
  GetMaintenanceWindowExecutionResult& WithTaskIds(TaskIdsT&& value) {
    SetTaskIds(std::forward<TaskIdsT>(value));
    return *this;
  }
  template <typename TaskIdsT = Aws::String>
  GetMaintenanceWindowExecutionResult& AddTaskIds(TaskIdsT&& value) {
    m_taskIdsHasBeenSet = true;
    m_taskIds.emplace_back(std::forward<TaskIdsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the maintenance window execution.</p>
   */
  inline MaintenanceWindowExecutionStatus GetStatus() const { return m_status; }
  inline void SetStatus(MaintenanceWindowExecutionStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline GetMaintenanceWindowExecutionResult& WithStatus(MaintenanceWindowExecutionStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The details explaining the status. Not available for all status values.</p>
   */
  inline const Aws::String& GetStatusDetails() const { return m_statusDetails; }
  template <typename StatusDetailsT = Aws::String>
  void SetStatusDetails(StatusDetailsT&& value) {
    m_statusDetailsHasBeenSet = true;
    m_statusDetails = std::forward<StatusDetailsT>(value);
  }
  template <typename StatusDetailsT = Aws::String>
  GetMaintenanceWindowExecutionResult& WithStatusDetails(StatusDetailsT&& value) {
    SetStatusDetails(std::forward<StatusDetailsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time the maintenance window started running.</p>
   */
  inline const Aws::Utils::DateTime& GetStartTime() const { return m_startTime; }
  template <typename StartTimeT = Aws::Utils::DateTime>
  void SetStartTime(StartTimeT&& value) {
    m_startTimeHasBeenSet = true;
    m_startTime = std::forward<StartTimeT>(value);
  }
  template <typename StartTimeT = Aws::Utils::DateTime>
  GetMaintenanceWindowExecutionResult& WithStartTime(StartTimeT&& value) {
    SetStartTime(std::forward<StartTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time the maintenance window finished running.</p>
   */
  inline const Aws::Utils::DateTime& GetEndTime() const { return m_endTime; }
  template <typename EndTimeT = Aws::Utils::DateTime>
  void SetEndTime(EndTimeT&& value) {
    m_endTimeHasBeenSet = true;
    m_endTime = std::forward<EndTimeT>(value);
  }
  template <typename EndTimeT = Aws::Utils::DateTime>
  GetMaintenanceWindowExecutionResult& WithEndTime(EndTimeT&& value) {
    SetEndTime(std::forward<EndTimeT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetMaintenanceWindowExecutionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_windowExecutionId;
  bool m_windowExecutionIdHasBeenSet = false;

  Aws::Vector<Aws::String> m_taskIds;
  bool m_taskIdsHasBeenSet = false;

  MaintenanceWindowExecutionStatus m_status{MaintenanceWindowExecutionStatus::NOT_SET};
  bool m_statusHasBeenSet = false;

  Aws::String m_statusDetails;
  bool m_statusDetailsHasBeenSet = false;

  Aws::Utils::DateTime m_startTime{};
  bool m_startTimeHasBeenSet = false;

  Aws::Utils::DateTime m_endTime{};
  bool m_endTimeHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SSM
}  // namespace Aws
