﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/servicecatalog-appregistry/AppRegistry_EXPORTS.h>
#include <aws/servicecatalog-appregistry/model/ApplicationTagStatus.h>
#include <aws/servicecatalog-appregistry/model/ResourcesListItem.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace AppRegistry {
namespace Model {

/**
 * <p> The result of the application tag that's applied to a resource.
 * </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ApplicationTagResult">AWS
 * API Reference</a></p>
 */
class ApplicationTagResult {
 public:
  AWS_APPREGISTRY_API ApplicationTagResult() = default;
  AWS_APPREGISTRY_API ApplicationTagResult(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPREGISTRY_API ApplicationTagResult& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPREGISTRY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> The application tag is in the process of being applied to a resource, was
   * successfully applied to a resource, or failed to apply to a resource. </p>
   */
  inline ApplicationTagStatus GetApplicationTagStatus() const { return m_applicationTagStatus; }
  inline bool ApplicationTagStatusHasBeenSet() const { return m_applicationTagStatusHasBeenSet; }
  inline void SetApplicationTagStatus(ApplicationTagStatus value) {
    m_applicationTagStatusHasBeenSet = true;
    m_applicationTagStatus = value;
  }
  inline ApplicationTagResult& WithApplicationTagStatus(ApplicationTagStatus value) {
    SetApplicationTagStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The message returned if the call fails. </p>
   */
  inline const Aws::String& GetErrorMessage() const { return m_errorMessage; }
  inline bool ErrorMessageHasBeenSet() const { return m_errorMessageHasBeenSet; }
  template <typename ErrorMessageT = Aws::String>
  void SetErrorMessage(ErrorMessageT&& value) {
    m_errorMessageHasBeenSet = true;
    m_errorMessage = std::forward<ErrorMessageT>(value);
  }
  template <typename ErrorMessageT = Aws::String>
  ApplicationTagResult& WithErrorMessage(ErrorMessageT&& value) {
    SetErrorMessage(std::forward<ErrorMessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The resources associated with an application </p>
   */
  inline const Aws::Vector<ResourcesListItem>& GetResources() const { return m_resources; }
  inline bool ResourcesHasBeenSet() const { return m_resourcesHasBeenSet; }
  template <typename ResourcesT = Aws::Vector<ResourcesListItem>>
  void SetResources(ResourcesT&& value) {
    m_resourcesHasBeenSet = true;
    m_resources = std::forward<ResourcesT>(value);
  }
  template <typename ResourcesT = Aws::Vector<ResourcesListItem>>
  ApplicationTagResult& WithResources(ResourcesT&& value) {
    SetResources(std::forward<ResourcesT>(value));
    return *this;
  }
  template <typename ResourcesT = ResourcesListItem>
  ApplicationTagResult& AddResources(ResourcesT&& value) {
    m_resourcesHasBeenSet = true;
    m_resources.emplace_back(std::forward<ResourcesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> A unique pagination token for each page of results. Make the call again with
   * the returned token to retrieve the next page of results. </p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ApplicationTagResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}
 private:
  ApplicationTagStatus m_applicationTagStatus{ApplicationTagStatus::NOT_SET};
  bool m_applicationTagStatusHasBeenSet = false;

  Aws::String m_errorMessage;
  bool m_errorMessageHasBeenSet = false;

  Aws::Vector<ResourcesListItem> m_resources;
  bool m_resourcesHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppRegistry
}  // namespace Aws
