﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/securityhub/model/CodeVulnerabilitiesFilePath.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SecurityHub {
namespace Model {

/**
 * <p>Provides details about the vulnerabilities found in your Lambda function
 * code. This field pertains to findings that Security Hub receives from Amazon
 * Inspector. </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/VulnerabilityCodeVulnerabilities">AWS
 * API Reference</a></p>
 */
class VulnerabilityCodeVulnerabilities {
 public:
  AWS_SECURITYHUB_API VulnerabilityCodeVulnerabilities() = default;
  AWS_SECURITYHUB_API VulnerabilityCodeVulnerabilities(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API VulnerabilityCodeVulnerabilities& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> The Common Weakness Enumeration (CWE) item associated with the detected code
   * vulnerability. </p>
   */
  inline const Aws::Vector<Aws::String>& GetCwes() const { return m_cwes; }
  inline bool CwesHasBeenSet() const { return m_cwesHasBeenSet; }
  template <typename CwesT = Aws::Vector<Aws::String>>
  void SetCwes(CwesT&& value) {
    m_cwesHasBeenSet = true;
    m_cwes = std::forward<CwesT>(value);
  }
  template <typename CwesT = Aws::Vector<Aws::String>>
  VulnerabilityCodeVulnerabilities& WithCwes(CwesT&& value) {
    SetCwes(std::forward<CwesT>(value));
    return *this;
  }
  template <typename CwesT = Aws::String>
  VulnerabilityCodeVulnerabilities& AddCwes(CwesT&& value) {
    m_cwesHasBeenSet = true;
    m_cwes.emplace_back(std::forward<CwesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Provides details about where a code vulnerability is located in your Lambda
   * function. </p>
   */
  inline const CodeVulnerabilitiesFilePath& GetFilePath() const { return m_filePath; }
  inline bool FilePathHasBeenSet() const { return m_filePathHasBeenSet; }
  template <typename FilePathT = CodeVulnerabilitiesFilePath>
  void SetFilePath(FilePathT&& value) {
    m_filePathHasBeenSet = true;
    m_filePath = std::forward<FilePathT>(value);
  }
  template <typename FilePathT = CodeVulnerabilitiesFilePath>
  VulnerabilityCodeVulnerabilities& WithFilePath(FilePathT&& value) {
    SetFilePath(std::forward<FilePathT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The Amazon Resource Name (ARN) of the Lambda layer in which the code
   * vulnerability is located. </p>
   */
  inline const Aws::String& GetSourceArn() const { return m_sourceArn; }
  inline bool SourceArnHasBeenSet() const { return m_sourceArnHasBeenSet; }
  template <typename SourceArnT = Aws::String>
  void SetSourceArn(SourceArnT&& value) {
    m_sourceArnHasBeenSet = true;
    m_sourceArn = std::forward<SourceArnT>(value);
  }
  template <typename SourceArnT = Aws::String>
  VulnerabilityCodeVulnerabilities& WithSourceArn(SourceArnT&& value) {
    SetSourceArn(std::forward<SourceArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_cwes;
  bool m_cwesHasBeenSet = false;

  CodeVulnerabilitiesFilePath m_filePath;
  bool m_filePathHasBeenSet = false;

  Aws::String m_sourceArn;
  bool m_sourceArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
