﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/sagemaker/model/MetadataProperties.h>
#include <aws/sagemaker/model/TrialComponentArtifact.h>
#include <aws/sagemaker/model/TrialComponentMetricSummary.h>
#include <aws/sagemaker/model/TrialComponentParameterValue.h>
#include <aws/sagemaker/model/TrialComponentSource.h>
#include <aws/sagemaker/model/TrialComponentStatus.h>
#include <aws/sagemaker/model/UserContext.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SageMaker {
namespace Model {
class DescribeTrialComponentResult {
 public:
  AWS_SAGEMAKER_API DescribeTrialComponentResult() = default;
  AWS_SAGEMAKER_API DescribeTrialComponentResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SAGEMAKER_API DescribeTrialComponentResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The name of the trial component.</p>
   */
  inline const Aws::String& GetTrialComponentName() const { return m_trialComponentName; }
  template <typename TrialComponentNameT = Aws::String>
  void SetTrialComponentName(TrialComponentNameT&& value) {
    m_trialComponentNameHasBeenSet = true;
    m_trialComponentName = std::forward<TrialComponentNameT>(value);
  }
  template <typename TrialComponentNameT = Aws::String>
  DescribeTrialComponentResult& WithTrialComponentName(TrialComponentNameT&& value) {
    SetTrialComponentName(std::forward<TrialComponentNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the trial component.</p>
   */
  inline const Aws::String& GetTrialComponentArn() const { return m_trialComponentArn; }
  template <typename TrialComponentArnT = Aws::String>
  void SetTrialComponentArn(TrialComponentArnT&& value) {
    m_trialComponentArnHasBeenSet = true;
    m_trialComponentArn = std::forward<TrialComponentArnT>(value);
  }
  template <typename TrialComponentArnT = Aws::String>
  DescribeTrialComponentResult& WithTrialComponentArn(TrialComponentArnT&& value) {
    SetTrialComponentArn(std::forward<TrialComponentArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the component as displayed. If <code>DisplayName</code> isn't
   * specified, <code>TrialComponentName</code> is displayed.</p>
   */
  inline const Aws::String& GetDisplayName() const { return m_displayName; }
  template <typename DisplayNameT = Aws::String>
  void SetDisplayName(DisplayNameT&& value) {
    m_displayNameHasBeenSet = true;
    m_displayName = std::forward<DisplayNameT>(value);
  }
  template <typename DisplayNameT = Aws::String>
  DescribeTrialComponentResult& WithDisplayName(DisplayNameT&& value) {
    SetDisplayName(std::forward<DisplayNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the source and, optionally, the job
   * type.</p>
   */
  inline const TrialComponentSource& GetSource() const { return m_source; }
  template <typename SourceT = TrialComponentSource>
  void SetSource(SourceT&& value) {
    m_sourceHasBeenSet = true;
    m_source = std::forward<SourceT>(value);
  }
  template <typename SourceT = TrialComponentSource>
  DescribeTrialComponentResult& WithSource(SourceT&& value) {
    SetSource(std::forward<SourceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the component. States include:</p> <ul> <li> <p>InProgress</p>
   * </li> <li> <p>Completed</p> </li> <li> <p>Failed</p> </li> </ul>
   */
  inline const TrialComponentStatus& GetStatus() const { return m_status; }
  template <typename StatusT = TrialComponentStatus>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = TrialComponentStatus>
  DescribeTrialComponentResult& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When the component started.</p>
   */
  inline const Aws::Utils::DateTime& GetStartTime() const { return m_startTime; }
  template <typename StartTimeT = Aws::Utils::DateTime>
  void SetStartTime(StartTimeT&& value) {
    m_startTimeHasBeenSet = true;
    m_startTime = std::forward<StartTimeT>(value);
  }
  template <typename StartTimeT = Aws::Utils::DateTime>
  DescribeTrialComponentResult& WithStartTime(StartTimeT&& value) {
    SetStartTime(std::forward<StartTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When the component ended.</p>
   */
  inline const Aws::Utils::DateTime& GetEndTime() const { return m_endTime; }
  template <typename EndTimeT = Aws::Utils::DateTime>
  void SetEndTime(EndTimeT&& value) {
    m_endTimeHasBeenSet = true;
    m_endTime = std::forward<EndTimeT>(value);
  }
  template <typename EndTimeT = Aws::Utils::DateTime>
  DescribeTrialComponentResult& WithEndTime(EndTimeT&& value) {
    SetEndTime(std::forward<EndTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When the component was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  DescribeTrialComponentResult& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Who created the trial component.</p>
   */
  inline const UserContext& GetCreatedBy() const { return m_createdBy; }
  template <typename CreatedByT = UserContext>
  void SetCreatedBy(CreatedByT&& value) {
    m_createdByHasBeenSet = true;
    m_createdBy = std::forward<CreatedByT>(value);
  }
  template <typename CreatedByT = UserContext>
  DescribeTrialComponentResult& WithCreatedBy(CreatedByT&& value) {
    SetCreatedBy(std::forward<CreatedByT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When the component was last modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedTime() const { return m_lastModifiedTime; }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  void SetLastModifiedTime(LastModifiedTimeT&& value) {
    m_lastModifiedTimeHasBeenSet = true;
    m_lastModifiedTime = std::forward<LastModifiedTimeT>(value);
  }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  DescribeTrialComponentResult& WithLastModifiedTime(LastModifiedTimeT&& value) {
    SetLastModifiedTime(std::forward<LastModifiedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Who last modified the component.</p>
   */
  inline const UserContext& GetLastModifiedBy() const { return m_lastModifiedBy; }
  template <typename LastModifiedByT = UserContext>
  void SetLastModifiedBy(LastModifiedByT&& value) {
    m_lastModifiedByHasBeenSet = true;
    m_lastModifiedBy = std::forward<LastModifiedByT>(value);
  }
  template <typename LastModifiedByT = UserContext>
  DescribeTrialComponentResult& WithLastModifiedBy(LastModifiedByT&& value) {
    SetLastModifiedBy(std::forward<LastModifiedByT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The hyperparameters of the component.</p>
   */
  inline const Aws::Map<Aws::String, TrialComponentParameterValue>& GetParameters() const { return m_parameters; }
  template <typename ParametersT = Aws::Map<Aws::String, TrialComponentParameterValue>>
  void SetParameters(ParametersT&& value) {
    m_parametersHasBeenSet = true;
    m_parameters = std::forward<ParametersT>(value);
  }
  template <typename ParametersT = Aws::Map<Aws::String, TrialComponentParameterValue>>
  DescribeTrialComponentResult& WithParameters(ParametersT&& value) {
    SetParameters(std::forward<ParametersT>(value));
    return *this;
  }
  template <typename ParametersKeyT = Aws::String, typename ParametersValueT = TrialComponentParameterValue>
  DescribeTrialComponentResult& AddParameters(ParametersKeyT&& key, ParametersValueT&& value) {
    m_parametersHasBeenSet = true;
    m_parameters.emplace(std::forward<ParametersKeyT>(key), std::forward<ParametersValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The input artifacts of the component.</p>
   */
  inline const Aws::Map<Aws::String, TrialComponentArtifact>& GetInputArtifacts() const { return m_inputArtifacts; }
  template <typename InputArtifactsT = Aws::Map<Aws::String, TrialComponentArtifact>>
  void SetInputArtifacts(InputArtifactsT&& value) {
    m_inputArtifactsHasBeenSet = true;
    m_inputArtifacts = std::forward<InputArtifactsT>(value);
  }
  template <typename InputArtifactsT = Aws::Map<Aws::String, TrialComponentArtifact>>
  DescribeTrialComponentResult& WithInputArtifacts(InputArtifactsT&& value) {
    SetInputArtifacts(std::forward<InputArtifactsT>(value));
    return *this;
  }
  template <typename InputArtifactsKeyT = Aws::String, typename InputArtifactsValueT = TrialComponentArtifact>
  DescribeTrialComponentResult& AddInputArtifacts(InputArtifactsKeyT&& key, InputArtifactsValueT&& value) {
    m_inputArtifactsHasBeenSet = true;
    m_inputArtifacts.emplace(std::forward<InputArtifactsKeyT>(key), std::forward<InputArtifactsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The output artifacts of the component.</p>
   */
  inline const Aws::Map<Aws::String, TrialComponentArtifact>& GetOutputArtifacts() const { return m_outputArtifacts; }
  template <typename OutputArtifactsT = Aws::Map<Aws::String, TrialComponentArtifact>>
  void SetOutputArtifacts(OutputArtifactsT&& value) {
    m_outputArtifactsHasBeenSet = true;
    m_outputArtifacts = std::forward<OutputArtifactsT>(value);
  }
  template <typename OutputArtifactsT = Aws::Map<Aws::String, TrialComponentArtifact>>
  DescribeTrialComponentResult& WithOutputArtifacts(OutputArtifactsT&& value) {
    SetOutputArtifacts(std::forward<OutputArtifactsT>(value));
    return *this;
  }
  template <typename OutputArtifactsKeyT = Aws::String, typename OutputArtifactsValueT = TrialComponentArtifact>
  DescribeTrialComponentResult& AddOutputArtifacts(OutputArtifactsKeyT&& key, OutputArtifactsValueT&& value) {
    m_outputArtifactsHasBeenSet = true;
    m_outputArtifacts.emplace(std::forward<OutputArtifactsKeyT>(key), std::forward<OutputArtifactsValueT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const MetadataProperties& GetMetadataProperties() const { return m_metadataProperties; }
  template <typename MetadataPropertiesT = MetadataProperties>
  void SetMetadataProperties(MetadataPropertiesT&& value) {
    m_metadataPropertiesHasBeenSet = true;
    m_metadataProperties = std::forward<MetadataPropertiesT>(value);
  }
  template <typename MetadataPropertiesT = MetadataProperties>
  DescribeTrialComponentResult& WithMetadataProperties(MetadataPropertiesT&& value) {
    SetMetadataProperties(std::forward<MetadataPropertiesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metrics for the component.</p>
   */
  inline const Aws::Vector<TrialComponentMetricSummary>& GetMetrics() const { return m_metrics; }
  template <typename MetricsT = Aws::Vector<TrialComponentMetricSummary>>
  void SetMetrics(MetricsT&& value) {
    m_metricsHasBeenSet = true;
    m_metrics = std::forward<MetricsT>(value);
  }
  template <typename MetricsT = Aws::Vector<TrialComponentMetricSummary>>
  DescribeTrialComponentResult& WithMetrics(MetricsT&& value) {
    SetMetrics(std::forward<MetricsT>(value));
    return *this;
  }
  template <typename MetricsT = TrialComponentMetricSummary>
  DescribeTrialComponentResult& AddMetrics(MetricsT&& value) {
    m_metricsHasBeenSet = true;
    m_metrics.emplace_back(std::forward<MetricsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the lineage group.</p>
   */
  inline const Aws::String& GetLineageGroupArn() const { return m_lineageGroupArn; }
  template <typename LineageGroupArnT = Aws::String>
  void SetLineageGroupArn(LineageGroupArnT&& value) {
    m_lineageGroupArnHasBeenSet = true;
    m_lineageGroupArn = std::forward<LineageGroupArnT>(value);
  }
  template <typename LineageGroupArnT = Aws::String>
  DescribeTrialComponentResult& WithLineageGroupArn(LineageGroupArnT&& value) {
    SetLineageGroupArn(std::forward<LineageGroupArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of ARNs and, if applicable, job types for multiple sources of an
   * experiment run.</p>
   */
  inline const Aws::Vector<TrialComponentSource>& GetSources() const { return m_sources; }
  template <typename SourcesT = Aws::Vector<TrialComponentSource>>
  void SetSources(SourcesT&& value) {
    m_sourcesHasBeenSet = true;
    m_sources = std::forward<SourcesT>(value);
  }
  template <typename SourcesT = Aws::Vector<TrialComponentSource>>
  DescribeTrialComponentResult& WithSources(SourcesT&& value) {
    SetSources(std::forward<SourcesT>(value));
    return *this;
  }
  template <typename SourcesT = TrialComponentSource>
  DescribeTrialComponentResult& AddSources(SourcesT&& value) {
    m_sourcesHasBeenSet = true;
    m_sources.emplace_back(std::forward<SourcesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeTrialComponentResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_trialComponentName;
  bool m_trialComponentNameHasBeenSet = false;

  Aws::String m_trialComponentArn;
  bool m_trialComponentArnHasBeenSet = false;

  Aws::String m_displayName;
  bool m_displayNameHasBeenSet = false;

  TrialComponentSource m_source;
  bool m_sourceHasBeenSet = false;

  TrialComponentStatus m_status;
  bool m_statusHasBeenSet = false;

  Aws::Utils::DateTime m_startTime{};
  bool m_startTimeHasBeenSet = false;

  Aws::Utils::DateTime m_endTime{};
  bool m_endTimeHasBeenSet = false;

  Aws::Utils::DateTime m_creationTime{};
  bool m_creationTimeHasBeenSet = false;

  UserContext m_createdBy;
  bool m_createdByHasBeenSet = false;

  Aws::Utils::DateTime m_lastModifiedTime{};
  bool m_lastModifiedTimeHasBeenSet = false;

  UserContext m_lastModifiedBy;
  bool m_lastModifiedByHasBeenSet = false;

  Aws::Map<Aws::String, TrialComponentParameterValue> m_parameters;
  bool m_parametersHasBeenSet = false;

  Aws::Map<Aws::String, TrialComponentArtifact> m_inputArtifacts;
  bool m_inputArtifactsHasBeenSet = false;

  Aws::Map<Aws::String, TrialComponentArtifact> m_outputArtifacts;
  bool m_outputArtifactsHasBeenSet = false;

  MetadataProperties m_metadataProperties;
  bool m_metadataPropertiesHasBeenSet = false;

  Aws::Vector<TrialComponentMetricSummary> m_metrics;
  bool m_metricsHasBeenSet = false;

  Aws::String m_lineageGroupArn;
  bool m_lineageGroupArnHasBeenSet = false;

  Aws::Vector<TrialComponentSource> m_sources;
  bool m_sourcesHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
