﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/rolesanywhere/RolesAnywhere_EXPORTS.h>
#include <aws/rolesanywhere/model/CrlDetail.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace RolesAnywhere {
namespace Model {
class UpdateCrlResult {
 public:
  AWS_ROLESANYWHERE_API UpdateCrlResult() = default;
  AWS_ROLESANYWHERE_API UpdateCrlResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ROLESANYWHERE_API UpdateCrlResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The state of the certificate revocation list (CRL) after a read or write
   * operation.</p>
   */
  inline const CrlDetail& GetCrl() const { return m_crl; }
  template <typename CrlT = CrlDetail>
  void SetCrl(CrlT&& value) {
    m_crlHasBeenSet = true;
    m_crl = std::forward<CrlT>(value);
  }
  template <typename CrlT = CrlDetail>
  UpdateCrlResult& WithCrl(CrlT&& value) {
    SetCrl(std::forward<CrlT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateCrlResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  CrlDetail m_crl;
  bool m_crlHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace RolesAnywhere
}  // namespace Aws
