﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/neptune/Neptune_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace Neptune {
namespace Model {

/**
 * <p>Metadata assigned to an Amazon Neptune resource consisting of a key-value
 * pair.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/Tag">AWS API
 * Reference</a></p>
 */
class Tag {
 public:
  AWS_NEPTUNE_API Tag() = default;
  AWS_NEPTUNE_API Tag(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_NEPTUNE_API Tag& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_NEPTUNE_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_NEPTUNE_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>A key is the required name of the tag. The string value can be from 1 to 128
   * Unicode characters in length and can't be prefixed with <code>aws:</code> or
   * <code>rds:</code>. The string can only contain the set of Unicode letters,
   * digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex:
   * "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
   */
  inline const Aws::String& GetKey() const { return m_key; }
  inline bool KeyHasBeenSet() const { return m_keyHasBeenSet; }
  template <typename KeyT = Aws::String>
  void SetKey(KeyT&& value) {
    m_keyHasBeenSet = true;
    m_key = std::forward<KeyT>(value);
  }
  template <typename KeyT = Aws::String>
  Tag& WithKey(KeyT&& value) {
    SetKey(std::forward<KeyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A value is the optional value of the tag. The string value can be from 1 to
   * 256 Unicode characters in length and can't be prefixed with <code>aws:</code> or
   * <code>rds:</code>. The string can only contain the set of Unicode letters,
   * digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex:
   * "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
   */
  inline const Aws::String& GetValue() const { return m_value; }
  inline bool ValueHasBeenSet() const { return m_valueHasBeenSet; }
  template <typename ValueT = Aws::String>
  void SetValue(ValueT&& value) {
    m_valueHasBeenSet = true;
    m_value = std::forward<ValueT>(value);
  }
  template <typename ValueT = Aws::String>
  Tag& WithValue(ValueT&& value) {
    SetValue(std::forward<ValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_key;
  bool m_keyHasBeenSet = false;

  Aws::String m_value;
  bool m_valueHasBeenSet = false;
};

}  // namespace Model
}  // namespace Neptune
}  // namespace Aws
