﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotsitewise/IoTSiteWise_EXPORTS.h>
#include <aws/iotsitewise/model/ConfigurationStatus.h>
#include <aws/iotsitewise/model/EncryptionType.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace IoTSiteWise {
namespace Model {
class PutDefaultEncryptionConfigurationResult {
 public:
  AWS_IOTSITEWISE_API PutDefaultEncryptionConfigurationResult() = default;
  AWS_IOTSITEWISE_API PutDefaultEncryptionConfigurationResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IOTSITEWISE_API PutDefaultEncryptionConfigurationResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The type of encryption used for the encryption configuration.</p>
   */
  inline EncryptionType GetEncryptionType() const { return m_encryptionType; }
  inline void SetEncryptionType(EncryptionType value) {
    m_encryptionTypeHasBeenSet = true;
    m_encryptionType = value;
  }
  inline PutDefaultEncryptionConfigurationResult& WithEncryptionType(EncryptionType value) {
    SetEncryptionType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Key ARN of the KMS key used for KMS encryption if you use
   * <code>KMS_BASED_ENCRYPTION</code>.</p>
   */
  inline const Aws::String& GetKmsKeyArn() const { return m_kmsKeyArn; }
  template <typename KmsKeyArnT = Aws::String>
  void SetKmsKeyArn(KmsKeyArnT&& value) {
    m_kmsKeyArnHasBeenSet = true;
    m_kmsKeyArn = std::forward<KmsKeyArnT>(value);
  }
  template <typename KmsKeyArnT = Aws::String>
  PutDefaultEncryptionConfigurationResult& WithKmsKeyArn(KmsKeyArnT&& value) {
    SetKmsKeyArn(std::forward<KmsKeyArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the account configuration. This contains the
   * <code>ConfigurationState</code>. If there is an error, it also contains the
   * <code>ErrorDetails</code>.</p>
   */
  inline const ConfigurationStatus& GetConfigurationStatus() const { return m_configurationStatus; }
  template <typename ConfigurationStatusT = ConfigurationStatus>
  void SetConfigurationStatus(ConfigurationStatusT&& value) {
    m_configurationStatusHasBeenSet = true;
    m_configurationStatus = std::forward<ConfigurationStatusT>(value);
  }
  template <typename ConfigurationStatusT = ConfigurationStatus>
  PutDefaultEncryptionConfigurationResult& WithConfigurationStatus(ConfigurationStatusT&& value) {
    SetConfigurationStatus(std::forward<ConfigurationStatusT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  PutDefaultEncryptionConfigurationResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  EncryptionType m_encryptionType{EncryptionType::NOT_SET};
  bool m_encryptionTypeHasBeenSet = false;

  Aws::String m_kmsKeyArn;
  bool m_kmsKeyArnHasBeenSet = false;

  ConfigurationStatus m_configurationStatus;
  bool m_configurationStatusHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTSiteWise
}  // namespace Aws
