﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotfleetwise/IoTFleetWise_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace IoTFleetWise {
namespace Model {

/**
 * <p>Information about the updated vehicle.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/UpdateVehicleResponseItem">AWS
 * API Reference</a></p>
 */
class UpdateVehicleResponseItem {
 public:
  AWS_IOTFLEETWISE_API UpdateVehicleResponseItem() = default;
  AWS_IOTFLEETWISE_API UpdateVehicleResponseItem(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTFLEETWISE_API UpdateVehicleResponseItem& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTFLEETWISE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The unique ID of the updated vehicle.</p>
   */
  inline const Aws::String& GetVehicleName() const { return m_vehicleName; }
  inline bool VehicleNameHasBeenSet() const { return m_vehicleNameHasBeenSet; }
  template <typename VehicleNameT = Aws::String>
  void SetVehicleName(VehicleNameT&& value) {
    m_vehicleNameHasBeenSet = true;
    m_vehicleName = std::forward<VehicleNameT>(value);
  }
  template <typename VehicleNameT = Aws::String>
  UpdateVehicleResponseItem& WithVehicleName(VehicleNameT&& value) {
    SetVehicleName(std::forward<VehicleNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the updated vehicle.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  UpdateVehicleResponseItem& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_vehicleName;
  bool m_vehicleNameHasBeenSet = false;

  Aws::String m_arn;
  bool m_arnHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTFleetWise
}  // namespace Aws
