﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotanalytics/IoTAnalytics_EXPORTS.h>
#include <aws/iotanalytics/model/Pipeline.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace IoTAnalytics {
namespace Model {
class DescribePipelineResult {
 public:
  AWS_IOTANALYTICS_API DescribePipelineResult() = default;
  AWS_IOTANALYTICS_API DescribePipelineResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IOTANALYTICS_API DescribePipelineResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A <code>Pipeline</code> object that contains information about the
   * pipeline.</p>
   */
  inline const Pipeline& GetPipeline() const { return m_pipeline; }
  template <typename PipelineT = Pipeline>
  void SetPipeline(PipelineT&& value) {
    m_pipelineHasBeenSet = true;
    m_pipeline = std::forward<PipelineT>(value);
  }
  template <typename PipelineT = Pipeline>
  DescribePipelineResult& WithPipeline(PipelineT&& value) {
    SetPipeline(std::forward<PipelineT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribePipelineResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Pipeline m_pipeline;
  bool m_pipelineHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTAnalytics
}  // namespace Aws
