﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotanalytics/IoTAnalytics_EXPORTS.h>
#include <aws/iotanalytics/model/RetentionPeriod.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace IoTAnalytics {
namespace Model {
class CreateDatastoreResult {
 public:
  AWS_IOTANALYTICS_API CreateDatastoreResult() = default;
  AWS_IOTANALYTICS_API CreateDatastoreResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IOTANALYTICS_API CreateDatastoreResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The name of the data store.</p>
   */
  inline const Aws::String& GetDatastoreName() const { return m_datastoreName; }
  template <typename DatastoreNameT = Aws::String>
  void SetDatastoreName(DatastoreNameT&& value) {
    m_datastoreNameHasBeenSet = true;
    m_datastoreName = std::forward<DatastoreNameT>(value);
  }
  template <typename DatastoreNameT = Aws::String>
  CreateDatastoreResult& WithDatastoreName(DatastoreNameT&& value) {
    SetDatastoreName(std::forward<DatastoreNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the data store.</p>
   */
  inline const Aws::String& GetDatastoreArn() const { return m_datastoreArn; }
  template <typename DatastoreArnT = Aws::String>
  void SetDatastoreArn(DatastoreArnT&& value) {
    m_datastoreArnHasBeenSet = true;
    m_datastoreArn = std::forward<DatastoreArnT>(value);
  }
  template <typename DatastoreArnT = Aws::String>
  CreateDatastoreResult& WithDatastoreArn(DatastoreArnT&& value) {
    SetDatastoreArn(std::forward<DatastoreArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>How long, in days, message data is kept for the data store.</p>
   */
  inline const RetentionPeriod& GetRetentionPeriod() const { return m_retentionPeriod; }
  template <typename RetentionPeriodT = RetentionPeriod>
  void SetRetentionPeriod(RetentionPeriodT&& value) {
    m_retentionPeriodHasBeenSet = true;
    m_retentionPeriod = std::forward<RetentionPeriodT>(value);
  }
  template <typename RetentionPeriodT = RetentionPeriod>
  CreateDatastoreResult& WithRetentionPeriod(RetentionPeriodT&& value) {
    SetRetentionPeriod(std::forward<RetentionPeriodT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateDatastoreResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_datastoreName;
  bool m_datastoreNameHasBeenSet = false;

  Aws::String m_datastoreArn;
  bool m_datastoreArnHasBeenSet = false;

  RetentionPeriod m_retentionPeriod;
  bool m_retentionPeriodHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTAnalytics
}  // namespace Aws
