﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/glue/model/SchemaVersionStatus.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Glue {
namespace Model {
class RegisterSchemaVersionResult {
 public:
  AWS_GLUE_API RegisterSchemaVersionResult() = default;
  AWS_GLUE_API RegisterSchemaVersionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_GLUE_API RegisterSchemaVersionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The unique ID that represents the version of this schema.</p>
   */
  inline const Aws::String& GetSchemaVersionId() const { return m_schemaVersionId; }
  template <typename SchemaVersionIdT = Aws::String>
  void SetSchemaVersionId(SchemaVersionIdT&& value) {
    m_schemaVersionIdHasBeenSet = true;
    m_schemaVersionId = std::forward<SchemaVersionIdT>(value);
  }
  template <typename SchemaVersionIdT = Aws::String>
  RegisterSchemaVersionResult& WithSchemaVersionId(SchemaVersionIdT&& value) {
    SetSchemaVersionId(std::forward<SchemaVersionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version of this schema (for sync flow only, in case this is the first
   * version).</p>
   */
  inline long long GetVersionNumber() const { return m_versionNumber; }
  inline void SetVersionNumber(long long value) {
    m_versionNumberHasBeenSet = true;
    m_versionNumber = value;
  }
  inline RegisterSchemaVersionResult& WithVersionNumber(long long value) {
    SetVersionNumber(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the schema version.</p>
   */
  inline SchemaVersionStatus GetStatus() const { return m_status; }
  inline void SetStatus(SchemaVersionStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline RegisterSchemaVersionResult& WithStatus(SchemaVersionStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  RegisterSchemaVersionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_schemaVersionId;
  bool m_schemaVersionIdHasBeenSet = false;

  long long m_versionNumber{0};
  bool m_versionNumberHasBeenSet = false;

  SchemaVersionStatus m_status{SchemaVersionStatus::NOT_SET};
  bool m_statusHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
