﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/dynamodb/DynamoDB_EXPORTS.h>
#include <aws/dynamodb/model/AttributeDefinition.h>
#include <aws/dynamodb/model/BillingMode.h>
#include <aws/dynamodb/model/GlobalSecondaryIndex.h>
#include <aws/dynamodb/model/KeySchemaElement.h>
#include <aws/dynamodb/model/OnDemandThroughput.h>
#include <aws/dynamodb/model/ProvisionedThroughput.h>
#include <aws/dynamodb/model/SSESpecification.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace DynamoDB {
namespace Model {

/**
 * <p> The parameters for the table created as part of the import operation.
 * </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TableCreationParameters">AWS
 * API Reference</a></p>
 */
class TableCreationParameters {
 public:
  AWS_DYNAMODB_API TableCreationParameters() = default;
  AWS_DYNAMODB_API TableCreationParameters(Aws::Utils::Json::JsonView jsonValue);
  AWS_DYNAMODB_API TableCreationParameters& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DYNAMODB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> The name of the table created as part of the import operation. </p>
   */
  inline const Aws::String& GetTableName() const { return m_tableName; }
  inline bool TableNameHasBeenSet() const { return m_tableNameHasBeenSet; }
  template <typename TableNameT = Aws::String>
  void SetTableName(TableNameT&& value) {
    m_tableNameHasBeenSet = true;
    m_tableName = std::forward<TableNameT>(value);
  }
  template <typename TableNameT = Aws::String>
  TableCreationParameters& WithTableName(TableNameT&& value) {
    SetTableName(std::forward<TableNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The attributes of the table created as part of the import operation. </p>
   */
  inline const Aws::Vector<AttributeDefinition>& GetAttributeDefinitions() const { return m_attributeDefinitions; }
  inline bool AttributeDefinitionsHasBeenSet() const { return m_attributeDefinitionsHasBeenSet; }
  template <typename AttributeDefinitionsT = Aws::Vector<AttributeDefinition>>
  void SetAttributeDefinitions(AttributeDefinitionsT&& value) {
    m_attributeDefinitionsHasBeenSet = true;
    m_attributeDefinitions = std::forward<AttributeDefinitionsT>(value);
  }
  template <typename AttributeDefinitionsT = Aws::Vector<AttributeDefinition>>
  TableCreationParameters& WithAttributeDefinitions(AttributeDefinitionsT&& value) {
    SetAttributeDefinitions(std::forward<AttributeDefinitionsT>(value));
    return *this;
  }
  template <typename AttributeDefinitionsT = AttributeDefinition>
  TableCreationParameters& AddAttributeDefinitions(AttributeDefinitionsT&& value) {
    m_attributeDefinitionsHasBeenSet = true;
    m_attributeDefinitions.emplace_back(std::forward<AttributeDefinitionsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The primary key and option sort key of the table created as part of the
   * import operation. </p>
   */
  inline const Aws::Vector<KeySchemaElement>& GetKeySchema() const { return m_keySchema; }
  inline bool KeySchemaHasBeenSet() const { return m_keySchemaHasBeenSet; }
  template <typename KeySchemaT = Aws::Vector<KeySchemaElement>>
  void SetKeySchema(KeySchemaT&& value) {
    m_keySchemaHasBeenSet = true;
    m_keySchema = std::forward<KeySchemaT>(value);
  }
  template <typename KeySchemaT = Aws::Vector<KeySchemaElement>>
  TableCreationParameters& WithKeySchema(KeySchemaT&& value) {
    SetKeySchema(std::forward<KeySchemaT>(value));
    return *this;
  }
  template <typename KeySchemaT = KeySchemaElement>
  TableCreationParameters& AddKeySchema(KeySchemaT&& value) {
    m_keySchemaHasBeenSet = true;
    m_keySchema.emplace_back(std::forward<KeySchemaT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The billing mode for provisioning the table created as part of the import
   * operation. </p>
   */
  inline BillingMode GetBillingMode() const { return m_billingMode; }
  inline bool BillingModeHasBeenSet() const { return m_billingModeHasBeenSet; }
  inline void SetBillingMode(BillingMode value) {
    m_billingModeHasBeenSet = true;
    m_billingMode = value;
  }
  inline TableCreationParameters& WithBillingMode(BillingMode value) {
    SetBillingMode(value);
    return *this;
  }
  ///@}

  ///@{

  inline const ProvisionedThroughput& GetProvisionedThroughput() const { return m_provisionedThroughput; }
  inline bool ProvisionedThroughputHasBeenSet() const { return m_provisionedThroughputHasBeenSet; }
  template <typename ProvisionedThroughputT = ProvisionedThroughput>
  void SetProvisionedThroughput(ProvisionedThroughputT&& value) {
    m_provisionedThroughputHasBeenSet = true;
    m_provisionedThroughput = std::forward<ProvisionedThroughputT>(value);
  }
  template <typename ProvisionedThroughputT = ProvisionedThroughput>
  TableCreationParameters& WithProvisionedThroughput(ProvisionedThroughputT&& value) {
    SetProvisionedThroughput(std::forward<ProvisionedThroughputT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const OnDemandThroughput& GetOnDemandThroughput() const { return m_onDemandThroughput; }
  inline bool OnDemandThroughputHasBeenSet() const { return m_onDemandThroughputHasBeenSet; }
  template <typename OnDemandThroughputT = OnDemandThroughput>
  void SetOnDemandThroughput(OnDemandThroughputT&& value) {
    m_onDemandThroughputHasBeenSet = true;
    m_onDemandThroughput = std::forward<OnDemandThroughputT>(value);
  }
  template <typename OnDemandThroughputT = OnDemandThroughput>
  TableCreationParameters& WithOnDemandThroughput(OnDemandThroughputT&& value) {
    SetOnDemandThroughput(std::forward<OnDemandThroughputT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const SSESpecification& GetSSESpecification() const { return m_sSESpecification; }
  inline bool SSESpecificationHasBeenSet() const { return m_sSESpecificationHasBeenSet; }
  template <typename SSESpecificationT = SSESpecification>
  void SetSSESpecification(SSESpecificationT&& value) {
    m_sSESpecificationHasBeenSet = true;
    m_sSESpecification = std::forward<SSESpecificationT>(value);
  }
  template <typename SSESpecificationT = SSESpecification>
  TableCreationParameters& WithSSESpecification(SSESpecificationT&& value) {
    SetSSESpecification(std::forward<SSESpecificationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The Global Secondary Indexes (GSI) of the table to be created as part of the
   * import operation. </p>
   */
  inline const Aws::Vector<GlobalSecondaryIndex>& GetGlobalSecondaryIndexes() const { return m_globalSecondaryIndexes; }
  inline bool GlobalSecondaryIndexesHasBeenSet() const { return m_globalSecondaryIndexesHasBeenSet; }
  template <typename GlobalSecondaryIndexesT = Aws::Vector<GlobalSecondaryIndex>>
  void SetGlobalSecondaryIndexes(GlobalSecondaryIndexesT&& value) {
    m_globalSecondaryIndexesHasBeenSet = true;
    m_globalSecondaryIndexes = std::forward<GlobalSecondaryIndexesT>(value);
  }
  template <typename GlobalSecondaryIndexesT = Aws::Vector<GlobalSecondaryIndex>>
  TableCreationParameters& WithGlobalSecondaryIndexes(GlobalSecondaryIndexesT&& value) {
    SetGlobalSecondaryIndexes(std::forward<GlobalSecondaryIndexesT>(value));
    return *this;
  }
  template <typename GlobalSecondaryIndexesT = GlobalSecondaryIndex>
  TableCreationParameters& AddGlobalSecondaryIndexes(GlobalSecondaryIndexesT&& value) {
    m_globalSecondaryIndexesHasBeenSet = true;
    m_globalSecondaryIndexes.emplace_back(std::forward<GlobalSecondaryIndexesT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_tableName;
  bool m_tableNameHasBeenSet = false;

  Aws::Vector<AttributeDefinition> m_attributeDefinitions;
  bool m_attributeDefinitionsHasBeenSet = false;

  Aws::Vector<KeySchemaElement> m_keySchema;
  bool m_keySchemaHasBeenSet = false;

  BillingMode m_billingMode{BillingMode::NOT_SET};
  bool m_billingModeHasBeenSet = false;

  ProvisionedThroughput m_provisionedThroughput;
  bool m_provisionedThroughputHasBeenSet = false;

  OnDemandThroughput m_onDemandThroughput;
  bool m_onDemandThroughputHasBeenSet = false;

  SSESpecification m_sSESpecification;
  bool m_sSESpecificationHasBeenSet = false;

  Aws::Vector<GlobalSecondaryIndex> m_globalSecondaryIndexes;
  bool m_globalSecondaryIndexesHasBeenSet = false;
};

}  // namespace Model
}  // namespace DynamoDB
}  // namespace Aws
