﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/billingconductor/BillingConductorRequest.h>
#include <aws/billingconductor/BillingConductor_EXPORTS.h>
#include <aws/billingconductor/model/CustomLineItemBillingPeriodRange.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace BillingConductor {
namespace Model {

/**
 */
class DeleteCustomLineItemRequest : public BillingConductorRequest {
 public:
  AWS_BILLINGCONDUCTOR_API DeleteCustomLineItemRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteCustomLineItem"; }

  AWS_BILLINGCONDUCTOR_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p> The ARN of the custom line item to be deleted. </p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  DeleteCustomLineItemRequest& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const CustomLineItemBillingPeriodRange& GetBillingPeriodRange() const { return m_billingPeriodRange; }
  inline bool BillingPeriodRangeHasBeenSet() const { return m_billingPeriodRangeHasBeenSet; }
  template <typename BillingPeriodRangeT = CustomLineItemBillingPeriodRange>
  void SetBillingPeriodRange(BillingPeriodRangeT&& value) {
    m_billingPeriodRangeHasBeenSet = true;
    m_billingPeriodRange = std::forward<BillingPeriodRangeT>(value);
  }
  template <typename BillingPeriodRangeT = CustomLineItemBillingPeriodRange>
  DeleteCustomLineItemRequest& WithBillingPeriodRange(BillingPeriodRangeT&& value) {
    SetBillingPeriodRange(std::forward<BillingPeriodRangeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;
  bool m_arnHasBeenSet = false;

  CustomLineItemBillingPeriodRange m_billingPeriodRange;
  bool m_billingPeriodRangeHasBeenSet = false;
};

}  // namespace Model
}  // namespace BillingConductor
}  // namespace Aws
