/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.tomcat.dbcp.dbcp2.ListException;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.dbcp2.datasources.InstanceKeyDataSource;

abstract class InstanceKeyDataSourceFactory
implements ObjectFactory {
    private static final Map<String, InstanceKeyDataSource> INSTANCE_MAP = new ConcurrentHashMap<String, InstanceKeyDataSource>();

    InstanceKeyDataSourceFactory() {
    }

    public static void closeAll() throws ListException {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>(INSTANCE_MAP.size());
        INSTANCE_MAP.entrySet().forEach(entry -> {
            if (entry != null) {
                InstanceKeyDataSource instanceKeyDataSource = (InstanceKeyDataSource)entry.getValue();
                Utils.close(instanceKeyDataSource, arrayList::add);
            }
        });
        INSTANCE_MAP.clear();
        if (!arrayList.isEmpty()) {
            throw new ListException("Could not close all InstanceKeyDataSource instances.", arrayList);
        }
    }

    protected static final Object deserialize(byte[] byArray) throws IOException, ClassNotFoundException {
        Object object;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
            object = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(objectInputStream);
            throw throwable;
        }
        Utils.closeQuietly(objectInputStream);
        return object;
    }

    static synchronized String registerNewInstance(InstanceKeyDataSource instanceKeyDataSource) {
        int n = 0;
        for (String string : INSTANCE_MAP.keySet()) {
            if (string == null) continue;
            try {
                n = Math.max(n, Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String string = String.valueOf(n + 1);
        INSTANCE_MAP.put(string, instanceKeyDataSource);
        return string;
    }

    static void removeInstance(String string) {
        if (string != null) {
            INSTANCE_MAP.remove(string);
        }
    }

    private Boolean booleanValueOf(RefAddr refAddr) {
        return Boolean.valueOf(this.toString(refAddr));
    }

    protected abstract InstanceKeyDataSource getNewInstance(Reference var1) throws IOException, ClassNotFoundException;

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws IOException, ClassNotFoundException {
        Reference reference;
        InstanceKeyDataSource instanceKeyDataSource = null;
        if (object instanceof Reference && this.isCorrectClass((reference = (Reference)object).getClassName())) {
            RefAddr refAddr = reference.get("instanceKey");
            if (this.hasContent(refAddr)) {
                instanceKeyDataSource = INSTANCE_MAP.get(refAddr.getContent());
            } else {
                String string = null;
                if (name != null) {
                    string = name.toString();
                    instanceKeyDataSource = INSTANCE_MAP.get(string);
                }
                if (instanceKeyDataSource == null) {
                    InstanceKeyDataSource instanceKeyDataSource2 = this.getNewInstance(reference);
                    this.setCommonProperties(reference, instanceKeyDataSource2);
                    instanceKeyDataSource = instanceKeyDataSource2;
                    if (string != null) {
                        INSTANCE_MAP.put(string, instanceKeyDataSource2);
                    }
                }
            }
        }
        return instanceKeyDataSource;
    }

    private boolean hasContent(RefAddr refAddr) {
        return refAddr != null && refAddr.getContent() != null;
    }

    protected abstract boolean isCorrectClass(String var1);

    boolean parseBoolean(RefAddr refAddr) {
        return Boolean.parseBoolean(this.toString(refAddr));
    }

    int parseInt(RefAddr refAddr) {
        return Integer.parseInt(this.toString(refAddr));
    }

    long parseLong(RefAddr refAddr) {
        return Long.parseLong(this.toString(refAddr));
    }

    private void setCommonProperties(Reference reference, InstanceKeyDataSource instanceKeyDataSource) throws IOException, ClassNotFoundException {
        RefAddr refAddr = reference.get("dataSourceName");
        if (this.hasContent(refAddr)) {
            instanceKeyDataSource.setDataSourceName(this.toString(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("description"))) {
            instanceKeyDataSource.setDescription(this.toString(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("jndiEnvironment"))) {
            byte[] byArray = (byte[])refAddr.getContent();
            instanceKeyDataSource.setJndiEnvironment((Properties)InstanceKeyDataSourceFactory.deserialize(byArray));
        }
        if (this.hasContent(refAddr = reference.get("loginTimeout"))) {
            instanceKeyDataSource.setLoginTimeout(this.toDurationFromSeconds(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("blockWhenExhausted"))) {
            instanceKeyDataSource.setDefaultBlockWhenExhausted(this.parseBoolean(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("evictionPolicyClassName"))) {
            instanceKeyDataSource.setDefaultEvictionPolicyClassName(this.toString(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("lifo"))) {
            instanceKeyDataSource.setDefaultLifo(this.parseBoolean(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("maxIdlePerKey"))) {
            instanceKeyDataSource.setDefaultMaxIdle(this.parseInt(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("maxTotalPerKey"))) {
            instanceKeyDataSource.setDefaultMaxTotal(this.parseInt(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("maxWaitMillis"))) {
            instanceKeyDataSource.setDefaultMaxWait(this.toDurationFromMillis(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("minEvictableIdleTimeMillis"))) {
            instanceKeyDataSource.setDefaultMinEvictableIdle(this.toDurationFromMillis(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("minIdlePerKey"))) {
            instanceKeyDataSource.setDefaultMinIdle(this.parseInt(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("numTestsPerEvictionRun"))) {
            instanceKeyDataSource.setDefaultNumTestsPerEvictionRun(this.parseInt(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("softMinEvictableIdleTimeMillis"))) {
            instanceKeyDataSource.setDefaultSoftMinEvictableIdle(this.toDurationFromMillis(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("testOnCreate"))) {
            instanceKeyDataSource.setDefaultTestOnCreate(this.parseBoolean(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("testOnBorrow"))) {
            instanceKeyDataSource.setDefaultTestOnBorrow(this.parseBoolean(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("testOnReturn"))) {
            instanceKeyDataSource.setDefaultTestOnReturn(this.parseBoolean(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("testWhileIdle"))) {
            instanceKeyDataSource.setDefaultTestWhileIdle(this.parseBoolean(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("timeBetweenEvictionRunsMillis"))) {
            instanceKeyDataSource.setDefaultDurationBetweenEvictionRuns(this.toDurationFromMillis(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("validationQuery"))) {
            instanceKeyDataSource.setValidationQuery(this.toString(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("validationQueryTimeout"))) {
            instanceKeyDataSource.setValidationQueryTimeout(this.toDurationFromSeconds(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("rollbackAfterValidation"))) {
            instanceKeyDataSource.setRollbackAfterValidation(this.parseBoolean(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("maxConnLifetimeMillis"))) {
            instanceKeyDataSource.setMaxConnLifetime(this.toDurationFromMillis(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("defaultAutoCommit"))) {
            instanceKeyDataSource.setDefaultAutoCommit(this.booleanValueOf(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("defaultTransactionIsolation"))) {
            instanceKeyDataSource.setDefaultTransactionIsolation(this.parseInt(refAddr));
        }
        if (this.hasContent(refAddr = reference.get("defaultReadOnly"))) {
            instanceKeyDataSource.setDefaultReadOnly(this.booleanValueOf(refAddr));
        }
    }

    private Duration toDurationFromMillis(RefAddr refAddr) {
        return Duration.ofMillis(this.parseLong(refAddr));
    }

    private Duration toDurationFromSeconds(RefAddr refAddr) {
        return Duration.ofSeconds(this.parseInt(refAddr));
    }

    String toString(RefAddr refAddr) {
        return refAddr.getContent().toString();
    }
}

