/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources.migrate;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedBiConsumer;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.search.Scroll;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.RequestHandler;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import org.opensearch.security.dlic.rest.api.SecurityApiDependencies;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.EndpointValidator;
import org.opensearch.security.dlic.rest.validation.RequestContentValidator;
import org.opensearch.security.dlic.rest.validation.ValidationResult;
import org.opensearch.security.resources.ResourceSharingIndexHandler;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.spi.resources.sharing.CreatedBy;
import org.opensearch.security.spi.resources.sharing.Recipient;
import org.opensearch.security.spi.resources.sharing.Recipients;
import org.opensearch.security.spi.resources.sharing.ResourceSharing;
import org.opensearch.security.spi.resources.sharing.ShareWith;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class MigrateResourceSharingInfoApiAction
extends AbstractApiAction {
    private static final Logger LOGGER = LogManager.getLogger(MigrateResourceSharingInfoApiAction.class);
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, "/resources/migrate")));
    private final ResourceSharingIndexHandler sharingIndexHandler;

    public MigrateResourceSharingInfoApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies, ResourceSharingIndexHandler sharingIndexHandler) {
        super(Endpoint.RESOURCE_SHARING, clusterService, threadPool, securityApiDependencies);
        this.sharingIndexHandler = sharingIndexHandler;
        this.requestHandlersBuilder.configureRequestHandlers(this::migrateApiRequestHandlers);
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected CType<?> getConfigType() {
        return null;
    }

    private void migrateApiRequestHandlers(RequestHandler.RequestHandlersBuilder b) {
        b.allMethodsNotImplemented().override(RestRequest.Method.POST, this::handleMigrate);
    }

    private void handleMigrate(RestChannel channel, RestRequest request, Client client) throws IOException {
        this.endpointValidator.createRequestContentValidator(new Object[0]).validate(request).map(pair -> this.loadCurrentSharingInfo(request, client)).map(this::createNewSharingRecords).valid(stats -> Responses.ok(channel, (ToXContent)stats)).error((CheckedBiConsumer<RestStatus, ToXContent, IOException>)((CheckedBiConsumer)(status, toXContent) -> Responses.response(channel, status, toXContent)));
    }

    private ValidationResult<Triple<String, String, List<SourceDoc>>> loadCurrentSharingInfo(RestRequest request, Client client) throws IOException {
        SearchHit[] hits;
        JsonNode body = Utils.toJsonNode(request.content().utf8ToString());
        String sourceIndex = body.get("source_index").asText();
        String userNamePath = body.get("username_path").asText();
        String backendRolesPath = body.get("backend_roles_path").asText();
        String defaultAccessLevel = body.has("default_access_level") ? body.get("default_access_level").asText() : "default";
        ArrayList<SourceDoc> results = new ArrayList<SourceDoc>();
        Scroll scroll = new Scroll(TimeValue.timeValueMinutes((long)1L));
        SearchRequest searchRequest = new SearchRequest(new String[]{sourceIndex}).scroll(scroll).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery()).size(1000));
        SearchResponse searchResponse = (SearchResponse)client.search(searchRequest).actionGet();
        String scrollId = searchResponse.getScrollId();
        while ((hits = searchResponse.getHits().getHits()) != null && hits.length != 0) {
            for (SearchHit hit : hits) {
                JsonNode rec = Utils.toJsonNode(hit.getSourceAsString());
                String id = hit.getId();
                String username = rec.at((String)(userNamePath.startsWith("/") ? userNamePath : "/" + userNamePath)).asText(null);
                JsonNode backendRolesNode = rec.at((String)(backendRolesPath.startsWith("/") ? backendRolesPath : "/" + backendRolesPath));
                ArrayList<String> backendRoles = new ArrayList<String>();
                if (backendRolesNode.isArray()) {
                    for (JsonNode br : backendRolesNode) {
                        backendRoles.add(br.asText());
                    }
                }
                results.add(new SourceDoc(id, username, backendRoles));
            }
            SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId).scroll(scroll);
            searchResponse = (SearchResponse)client.searchScroll(scrollRequest).actionGet();
            scrollId = searchResponse.getScrollId();
        }
        ClearScrollRequest clear = new ClearScrollRequest();
        clear.addScrollId(scrollId);
        client.clearScroll(clear).actionGet();
        return ValidationResult.success(Triple.of((Object)sourceIndex, (Object)defaultAccessLevel, results));
    }

    private ValidationResult<MigrationStats> createNewSharingRecords(Triple<String, String, List<SourceDoc>> sourceInfo) throws IOException {
        AtomicInteger migratedCount = new AtomicInteger();
        AtomicReference skippedNoUser = new AtomicReference();
        skippedNoUser.set(new HashSet());
        AtomicInteger failureCount = new AtomicInteger();
        List docs = (List)sourceInfo.getRight();
        int total = docs.size();
        CountDownLatch migrationStatsLatch = new CountDownLatch(total);
        for (SourceDoc doc : docs) {
            String resourceId = doc.resourceId;
            if (resourceId == null) {
                failureCount.getAndIncrement();
                migrationStatsLatch.countDown();
                continue;
            }
            String username = doc.username;
            if (username == null || username.isEmpty()) {
                LOGGER.debug("Record without associated user, skipping entirely: {}", (Object)doc.resourceId);
                ((Set)skippedNoUser.get()).add(doc.resourceId);
                migrationStatsLatch.countDown();
                continue;
            }
            try {
                CreatedBy createdBy = new CreatedBy(username);
                List<String> backendRoles = doc.backendRoles;
                ShareWith shareWith = null;
                if (!backendRoles.isEmpty()) {
                    Recipients recipients = new Recipients(Map.of(Recipient.BACKEND_ROLES, new HashSet<String>(backendRoles)));
                    shareWith = new ShareWith(Map.of((String)sourceInfo.getMiddle(), recipients));
                }
                ActionListener listener = ActionListener.wrap(entry -> {
                    LOGGER.debug("Successfully migrated a resource sharing entry {} for resource {} within index {}", entry, (Object)resourceId, sourceInfo.getLeft());
                    migratedCount.getAndIncrement();
                    migrationStatsLatch.countDown();
                }, e -> {
                    LOGGER.debug(e.getMessage());
                    failureCount.getAndIncrement();
                    migrationStatsLatch.countDown();
                });
                this.sharingIndexHandler.indexResourceSharing(resourceId, (String)sourceInfo.getLeft(), createdBy, shareWith, (ActionListener<ResourceSharing>)listener);
            }
            catch (Exception e2) {
                LOGGER.warn("Failed indexing sharing info for [{}]: {}", (Object)resourceId, (Object)e2.getMessage());
                failureCount.getAndIncrement();
                migrationStatsLatch.countDown();
            }
        }
        try {
            migrationStatsLatch.await();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting for migration to finish", ie);
        }
        String summary = String.format("Migration complete. migrated %d; skippedNoUser %d; failed %d", migratedCount.get(), ((Set)skippedNoUser.get()).size(), failureCount.get());
        MigrationStats stats = new MigrationStats(summary, (Set)skippedNoUser.get());
        return ValidationResult.success(stats);
    }

    @Override
    protected EndpointValidator createEndpointValidator() {
        return new EndpointValidator(){

            @Override
            public Endpoint endpoint() {
                return MigrateResourceSharingInfoApiAction.this.endpoint;
            }

            @Override
            public RestApiAdminPrivilegesEvaluator restApiAdminPrivilegesEvaluator() {
                return MigrateResourceSharingInfoApiAction.this.securityApiDependencies.restApiAdminPrivilegesEvaluator();
            }

            @Override
            public RequestContentValidator createRequestContentValidator(Object ... params) {
                return RequestContentValidator.of(new RequestContentValidator.ValidationContext(){

                    @Override
                    public Object[] params() {
                        return new Object[0];
                    }

                    @Override
                    public Settings settings() {
                        return MigrateResourceSharingInfoApiAction.this.securityApiDependencies.settings();
                    }

                    @Override
                    public Set<String> mandatoryKeys() {
                        return ImmutableSet.of((Object)"source_index", (Object)"username_path", (Object)"backend_roles_path");
                    }

                    @Override
                    public Map<String, RequestContentValidator.DataType> allowedKeys() {
                        return ImmutableMap.builder().put((Object)"source_index", (Object)RequestContentValidator.DataType.STRING).put((Object)"username_path", (Object)RequestContentValidator.DataType.STRING).put((Object)"backend_roles_path", (Object)RequestContentValidator.DataType.STRING).put((Object)"default_access_level", (Object)RequestContentValidator.DataType.STRING).build();
                    }
                });
            }
        };
    }

    static class SourceDoc {
        String resourceId;
        String username;
        List<String> backendRoles;

        public SourceDoc(String id, String username, List<String> backendRoles) {
            this.resourceId = id;
            this.username = username;
            this.backendRoles = backendRoles;
        }
    }

    static class MigrationStats
    implements ToXContentObject {
        private final String summary;
        private final Set<String> skippedResources;

        public MigrationStats(String summary, Set<String> skippedResources) {
            this.summary = summary;
            this.skippedResources = skippedResources;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("summary", this.summary);
            builder.array("skippedResources", this.skippedResources.toArray(new String[0]));
            builder.endObject();
            return builder;
        }
    }
}

