/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import org.jooq.AlterViewFinalStep;
import org.jooq.AlterViewStep;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class AlterViewImpl
extends AbstractQuery
implements AlterViewStep,
AlterViewFinalStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.ALTER_VIEW};
    private final Table<?> view;
    private final boolean ifExists;
    private Table<?> renameTo;

    AlterViewImpl(Configuration configuration, Table<?> view) {
        this(configuration, view, false);
    }

    AlterViewImpl(Configuration configuration, Table<?> view, boolean ifExists) {
        super(configuration);
        this.view = view;
        this.ifExists = ifExists;
    }

    @Override
    public final AlterViewImpl renameTo(Table<?> newName) {
        this.renameTo = newName;
        return this;
    }

    @Override
    public final AlterViewImpl renameTo(Name newName) {
        return this.renameTo((Table)DSL.table(newName));
    }

    @Override
    public final AlterViewImpl renameTo(String newName) {
        return this.renameTo(DSL.name(newName));
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !Arrays.asList(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD).contains((Object)ctx.family());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.beginTryCatchIfExists(ctx, DDLStatementType.ALTER_VIEW, this.view);
            this.accept0(ctx);
            Tools.endTryCatchIfExists(ctx, DDLStatementType.ALTER_VIEW, this.view);
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        this.accept1(ctx);
    }

    private final void accept1(Context<?> ctx) {
        ctx.start(Clause.ALTER_VIEW_VIEW).visit(Keywords.K_ALTER).sql(' ').visit(ctx.family() == SQLDialect.HSQLDB ? Keywords.K_TABLE : Keywords.K_VIEW);
        if (this.ifExists && this.supportsIfExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
        }
        ctx.sql(' ').visit(this.view).end(Clause.ALTER_VIEW_VIEW).formatIndentStart().formatSeparator();
        if (this.renameTo != null) {
            boolean qualify = ctx.qualify();
            ctx.start(Clause.ALTER_VIEW_RENAME).qualify(false).visit(Keywords.K_RENAME_TO).sql(' ').visit(this.renameTo).qualify(qualify).end(Clause.ALTER_VIEW_RENAME);
        }
        ctx.formatIndentEnd();
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

