/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.info;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.NodeRole;
import org.opensearch.client.opensearch._types.PluginStats;
import org.opensearch.client.opensearch.nodes.info.NodeInfoAggregation;
import org.opensearch.client.opensearch.nodes.info.NodeInfoHttp;
import org.opensearch.client.opensearch.nodes.info.NodeInfoIngest;
import org.opensearch.client.opensearch.nodes.info.NodeInfoNetwork;
import org.opensearch.client.opensearch.nodes.info.NodeInfoSearchPipelines;
import org.opensearch.client.opensearch.nodes.info.NodeInfoSettings;
import org.opensearch.client.opensearch.nodes.info.NodeInfoTransport;
import org.opensearch.client.opensearch.nodes.info.NodeJvmInfo;
import org.opensearch.client.opensearch.nodes.info.NodeOperatingSystemInfo;
import org.opensearch.client.opensearch.nodes.info.NodeProcessInfo;
import org.opensearch.client.opensearch.nodes.info.NodeThreadPoolInfo;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NodeInfo
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, NodeInfo> {
    @Nonnull
    private final Map<String, NodeInfoAggregation> aggregations;
    @Nonnull
    private final Map<String, String> attributes;
    @Nullable
    private final String buildFlavor;
    @Nonnull
    private final String buildHash;
    @Nonnull
    private final String buildType;
    @Nullable
    private final String host;
    @Nullable
    private final NodeInfoHttp http;
    @Nullable
    private final NodeInfoIngest ingest;
    @Nullable
    private final String ip;
    @Nullable
    private final NodeJvmInfo jvm;
    @Nonnull
    private final List<PluginStats> modules;
    @Nonnull
    private final String name;
    @Nullable
    private final NodeInfoNetwork network;
    @Nullable
    private final NodeOperatingSystemInfo os;
    @Nonnull
    private final List<PluginStats> plugins;
    @Nullable
    private final NodeProcessInfo process;
    @Nonnull
    private final List<NodeRole> roles;
    @Nullable
    private final NodeInfoSearchPipelines searchPipelines;
    @Nullable
    private final NodeInfoSettings settings;
    @Nonnull
    private final Map<String, NodeThreadPoolInfo> threadPool;
    @Nullable
    private final JsonData totalIndexingBuffer;
    @Nullable
    private final JsonData totalIndexingBufferInBytes;
    @Nullable
    private final NodeInfoTransport transport;
    @Nullable
    private final String transportAddress;
    @Nonnull
    private final String version;
    public static final JsonpDeserializer<NodeInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfo::setupNodeInfoDeserializer);

    private NodeInfo(Builder builder) {
        this.aggregations = ApiTypeHelper.unmodifiable(builder.aggregations);
        this.attributes = ApiTypeHelper.unmodifiable(builder.attributes);
        this.buildFlavor = builder.buildFlavor;
        this.buildHash = ApiTypeHelper.requireNonNull(builder.buildHash, this, "buildHash");
        this.buildType = ApiTypeHelper.requireNonNull(builder.buildType, this, "buildType");
        this.host = builder.host;
        this.http = builder.http;
        this.ingest = builder.ingest;
        this.ip = builder.ip;
        this.jvm = builder.jvm;
        this.modules = ApiTypeHelper.unmodifiable(builder.modules);
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.network = builder.network;
        this.os = builder.os;
        this.plugins = ApiTypeHelper.unmodifiable(builder.plugins);
        this.process = builder.process;
        this.roles = ApiTypeHelper.unmodifiableRequired(builder.roles, (Object)this, "roles");
        this.searchPipelines = builder.searchPipelines;
        this.settings = builder.settings;
        this.threadPool = ApiTypeHelper.unmodifiable(builder.threadPool);
        this.totalIndexingBuffer = builder.totalIndexingBuffer;
        this.totalIndexingBufferInBytes = builder.totalIndexingBufferInBytes;
        this.transport = builder.transport;
        this.transportAddress = builder.transportAddress;
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
    }

    public static NodeInfo of(Function<Builder, ObjectBuilder<NodeInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, NodeInfoAggregation> aggregations() {
        return this.aggregations;
    }

    @Nonnull
    public final Map<String, String> attributes() {
        return this.attributes;
    }

    @Nullable
    public final String buildFlavor() {
        return this.buildFlavor;
    }

    @Nonnull
    public final String buildHash() {
        return this.buildHash;
    }

    @Nonnull
    public final String buildType() {
        return this.buildType;
    }

    @Nullable
    public final String host() {
        return this.host;
    }

    @Nullable
    public final NodeInfoHttp http() {
        return this.http;
    }

    @Nullable
    public final NodeInfoIngest ingest() {
        return this.ingest;
    }

    @Nullable
    public final String ip() {
        return this.ip;
    }

    @Nullable
    public final NodeJvmInfo jvm() {
        return this.jvm;
    }

    @Nonnull
    public final List<PluginStats> modules() {
        return this.modules;
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    @Nullable
    public final NodeInfoNetwork network() {
        return this.network;
    }

    @Nullable
    public final NodeOperatingSystemInfo os() {
        return this.os;
    }

    @Nonnull
    public final List<PluginStats> plugins() {
        return this.plugins;
    }

    @Nullable
    public final NodeProcessInfo process() {
        return this.process;
    }

    @Nonnull
    public final List<NodeRole> roles() {
        return this.roles;
    }

    @Nullable
    public final NodeInfoSearchPipelines searchPipelines() {
        return this.searchPipelines;
    }

    @Nullable
    public final NodeInfoSettings settings() {
        return this.settings;
    }

    @Nonnull
    public final Map<String, NodeThreadPoolInfo> threadPool() {
        return this.threadPool;
    }

    @Nullable
    public final JsonData totalIndexingBuffer() {
        return this.totalIndexingBuffer;
    }

    @Nullable
    public final JsonData totalIndexingBufferInBytes() {
        return this.totalIndexingBufferInBytes;
    }

    @Nullable
    public final NodeInfoTransport transport() {
        return this.transport;
    }

    @Nullable
    public final String transportAddress() {
        return this.transportAddress;
    }

    @Nonnull
    public final String version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, NodeInfoAggregation> entry : this.aggregations.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.attributes)) {
            generator.writeKey("attributes");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (this.buildFlavor != null) {
            generator.writeKey("build_flavor");
            generator.write(this.buildFlavor);
        }
        generator.writeKey("build_hash");
        generator.write(this.buildHash);
        generator.writeKey("build_type");
        generator.write(this.buildType);
        if (this.host != null) {
            generator.writeKey("host");
            generator.write(this.host);
        }
        if (this.http != null) {
            generator.writeKey("http");
            this.http.serialize(generator, mapper);
        }
        if (this.ingest != null) {
            generator.writeKey("ingest");
            this.ingest.serialize(generator, mapper);
        }
        if (this.ip != null) {
            generator.writeKey("ip");
            generator.write(this.ip);
        }
        if (this.jvm != null) {
            generator.writeKey("jvm");
            this.jvm.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.modules)) {
            generator.writeKey("modules");
            generator.writeStartArray();
            for (PluginStats pluginStats : this.modules) {
                pluginStats.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("name");
        generator.write(this.name);
        if (this.network != null) {
            generator.writeKey("network");
            this.network.serialize(generator, mapper);
        }
        if (this.os != null) {
            generator.writeKey("os");
            this.os.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.plugins)) {
            generator.writeKey("plugins");
            generator.writeStartArray();
            for (PluginStats pluginStats : this.plugins) {
                pluginStats.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.process != null) {
            generator.writeKey("process");
            this.process.serialize(generator, mapper);
        }
        generator.writeKey("roles");
        generator.writeStartArray();
        for (NodeRole nodeRole : this.roles) {
            nodeRole.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.searchPipelines != null) {
            generator.writeKey("search_pipelines");
            this.searchPipelines.serialize(generator, mapper);
        }
        if (this.settings != null) {
            generator.writeKey("settings");
            this.settings.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.threadPool)) {
            generator.writeKey("thread_pool");
            generator.writeStartObject();
            for (Map.Entry entry : this.threadPool.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((NodeThreadPoolInfo)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.totalIndexingBuffer != null) {
            generator.writeKey("total_indexing_buffer");
            this.totalIndexingBuffer.serialize(generator, mapper);
        }
        if (this.totalIndexingBufferInBytes != null) {
            generator.writeKey("total_indexing_buffer_in_bytes");
            this.totalIndexingBufferInBytes.serialize(generator, mapper);
        }
        if (this.transport != null) {
            generator.writeKey("transport");
            this.transport.serialize(generator, mapper);
        }
        if (this.transportAddress != null) {
            generator.writeKey("transport_address");
            generator.write(this.transportAddress);
        }
        generator.writeKey("version");
        generator.write(this.version);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNodeInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(NodeInfoAggregation._DESERIALIZER), "aggregations");
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes");
        op.add(Builder::buildFlavor, JsonpDeserializer.stringDeserializer(), "build_flavor");
        op.add(Builder::buildHash, JsonpDeserializer.stringDeserializer(), "build_hash");
        op.add(Builder::buildType, JsonpDeserializer.stringDeserializer(), "build_type");
        op.add(Builder::host, JsonpDeserializer.stringDeserializer(), "host");
        op.add(Builder::http, NodeInfoHttp._DESERIALIZER, "http");
        op.add(Builder::ingest, NodeInfoIngest._DESERIALIZER, "ingest");
        op.add(Builder::ip, JsonpDeserializer.stringDeserializer(), "ip");
        op.add(Builder::jvm, NodeJvmInfo._DESERIALIZER, "jvm");
        op.add(Builder::modules, JsonpDeserializer.arrayDeserializer(PluginStats._DESERIALIZER), "modules");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::network, NodeInfoNetwork._DESERIALIZER, "network");
        op.add(Builder::os, NodeOperatingSystemInfo._DESERIALIZER, "os");
        op.add(Builder::plugins, JsonpDeserializer.arrayDeserializer(PluginStats._DESERIALIZER), "plugins");
        op.add(Builder::process, NodeProcessInfo._DESERIALIZER, "process");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(NodeRole._DESERIALIZER), "roles");
        op.add(Builder::searchPipelines, NodeInfoSearchPipelines._DESERIALIZER, "search_pipelines");
        op.add(Builder::settings, NodeInfoSettings._DESERIALIZER, "settings");
        op.add(Builder::threadPool, JsonpDeserializer.stringMapDeserializer(NodeThreadPoolInfo._DESERIALIZER), "thread_pool");
        op.add(Builder::totalIndexingBuffer, JsonData._DESERIALIZER, "total_indexing_buffer");
        op.add(Builder::totalIndexingBufferInBytes, JsonData._DESERIALIZER, "total_indexing_buffer_in_bytes");
        op.add(Builder::transport, NodeInfoTransport._DESERIALIZER, "transport");
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.aggregations);
        result = 31 * result + Objects.hashCode(this.attributes);
        result = 31 * result + Objects.hashCode(this.buildFlavor);
        result = 31 * result + this.buildHash.hashCode();
        result = 31 * result + this.buildType.hashCode();
        result = 31 * result + Objects.hashCode(this.host);
        result = 31 * result + Objects.hashCode(this.http);
        result = 31 * result + Objects.hashCode(this.ingest);
        result = 31 * result + Objects.hashCode(this.ip);
        result = 31 * result + Objects.hashCode(this.jvm);
        result = 31 * result + Objects.hashCode(this.modules);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Objects.hashCode(this.network);
        result = 31 * result + Objects.hashCode(this.os);
        result = 31 * result + Objects.hashCode(this.plugins);
        result = 31 * result + Objects.hashCode(this.process);
        result = 31 * result + this.roles.hashCode();
        result = 31 * result + Objects.hashCode(this.searchPipelines);
        result = 31 * result + Objects.hashCode(this.settings);
        result = 31 * result + Objects.hashCode(this.threadPool);
        result = 31 * result + Objects.hashCode(this.totalIndexingBuffer);
        result = 31 * result + Objects.hashCode(this.totalIndexingBufferInBytes);
        result = 31 * result + Objects.hashCode(this.transport);
        result = 31 * result + Objects.hashCode(this.transportAddress);
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInfo other = (NodeInfo)o;
        return Objects.equals(this.aggregations, other.aggregations) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.buildFlavor, other.buildFlavor) && this.buildHash.equals(other.buildHash) && this.buildType.equals(other.buildType) && Objects.equals(this.host, other.host) && Objects.equals(this.http, other.http) && Objects.equals(this.ingest, other.ingest) && Objects.equals(this.ip, other.ip) && Objects.equals(this.jvm, other.jvm) && Objects.equals(this.modules, other.modules) && this.name.equals(other.name) && Objects.equals(this.network, other.network) && Objects.equals(this.os, other.os) && Objects.equals(this.plugins, other.plugins) && Objects.equals(this.process, other.process) && this.roles.equals(other.roles) && Objects.equals(this.searchPipelines, other.searchPipelines) && Objects.equals(this.settings, other.settings) && Objects.equals(this.threadPool, other.threadPool) && Objects.equals(this.totalIndexingBuffer, other.totalIndexingBuffer) && Objects.equals(this.totalIndexingBufferInBytes, other.totalIndexingBufferInBytes) && Objects.equals(this.transport, other.transport) && Objects.equals(this.transportAddress, other.transportAddress) && this.version.equals(other.version);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, NodeInfo> {
        @Nullable
        private Map<String, NodeInfoAggregation> aggregations;
        @Nullable
        private Map<String, String> attributes;
        @Nullable
        private String buildFlavor;
        private String buildHash;
        private String buildType;
        @Nullable
        private String host;
        @Nullable
        private NodeInfoHttp http;
        @Nullable
        private NodeInfoIngest ingest;
        @Nullable
        private String ip;
        @Nullable
        private NodeJvmInfo jvm;
        @Nullable
        private List<PluginStats> modules;
        private String name;
        @Nullable
        private NodeInfoNetwork network;
        @Nullable
        private NodeOperatingSystemInfo os;
        @Nullable
        private List<PluginStats> plugins;
        @Nullable
        private NodeProcessInfo process;
        private List<NodeRole> roles;
        @Nullable
        private NodeInfoSearchPipelines searchPipelines;
        @Nullable
        private NodeInfoSettings settings;
        @Nullable
        private Map<String, NodeThreadPoolInfo> threadPool;
        @Nullable
        private JsonData totalIndexingBuffer;
        @Nullable
        private JsonData totalIndexingBufferInBytes;
        @Nullable
        private NodeInfoTransport transport;
        @Nullable
        private String transportAddress;
        private String version;

        public Builder() {
        }

        private Builder(NodeInfo o) {
            this.aggregations = Builder._mapCopy(o.aggregations);
            this.attributes = Builder._mapCopy(o.attributes);
            this.buildFlavor = o.buildFlavor;
            this.buildHash = o.buildHash;
            this.buildType = o.buildType;
            this.host = o.host;
            this.http = o.http;
            this.ingest = o.ingest;
            this.ip = o.ip;
            this.jvm = o.jvm;
            this.modules = Builder._listCopy(o.modules);
            this.name = o.name;
            this.network = o.network;
            this.os = o.os;
            this.plugins = Builder._listCopy(o.plugins);
            this.process = o.process;
            this.roles = Builder._listCopy(o.roles);
            this.searchPipelines = o.searchPipelines;
            this.settings = o.settings;
            this.threadPool = Builder._mapCopy(o.threadPool);
            this.totalIndexingBuffer = o.totalIndexingBuffer;
            this.totalIndexingBufferInBytes = o.totalIndexingBufferInBytes;
            this.transport = o.transport;
            this.transportAddress = o.transportAddress;
            this.version = o.version;
        }

        private Builder(Builder o) {
            this.aggregations = Builder._mapCopy(o.aggregations);
            this.attributes = Builder._mapCopy(o.attributes);
            this.buildFlavor = o.buildFlavor;
            this.buildHash = o.buildHash;
            this.buildType = o.buildType;
            this.host = o.host;
            this.http = o.http;
            this.ingest = o.ingest;
            this.ip = o.ip;
            this.jvm = o.jvm;
            this.modules = Builder._listCopy(o.modules);
            this.name = o.name;
            this.network = o.network;
            this.os = o.os;
            this.plugins = Builder._listCopy(o.plugins);
            this.process = o.process;
            this.roles = Builder._listCopy(o.roles);
            this.searchPipelines = o.searchPipelines;
            this.settings = o.settings;
            this.threadPool = Builder._mapCopy(o.threadPool);
            this.totalIndexingBuffer = o.totalIndexingBuffer;
            this.totalIndexingBufferInBytes = o.totalIndexingBufferInBytes;
            this.transport = o.transport;
            this.transportAddress = o.transportAddress;
            this.version = o.version;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder aggregations(Map<String, NodeInfoAggregation> map) {
            this.aggregations = Builder._mapPutAll(this.aggregations, map);
            return this;
        }

        @Nonnull
        public final Builder aggregations(String key, NodeInfoAggregation value) {
            this.aggregations = Builder._mapPut(this.aggregations, key, value);
            return this;
        }

        @Nonnull
        public final Builder aggregations(String key, Function<NodeInfoAggregation.Builder, ObjectBuilder<NodeInfoAggregation>> fn) {
            return this.aggregations(key, fn.apply(new NodeInfoAggregation.Builder()).build());
        }

        @Nonnull
        public final Builder attributes(Map<String, String> map) {
            this.attributes = Builder._mapPutAll(this.attributes, map);
            return this;
        }

        @Nonnull
        public final Builder attributes(String key, String value) {
            this.attributes = Builder._mapPut(this.attributes, key, value);
            return this;
        }

        @Nonnull
        public final Builder buildFlavor(@Nullable String value) {
            this.buildFlavor = value;
            return this;
        }

        @Nonnull
        public final Builder buildHash(String value) {
            this.buildHash = value;
            return this;
        }

        @Nonnull
        public final Builder buildType(String value) {
            this.buildType = value;
            return this;
        }

        @Nonnull
        public final Builder host(@Nullable String value) {
            this.host = value;
            return this;
        }

        @Nonnull
        public final Builder http(@Nullable NodeInfoHttp value) {
            this.http = value;
            return this;
        }

        @Nonnull
        public final Builder http(Function<NodeInfoHttp.Builder, ObjectBuilder<NodeInfoHttp>> fn) {
            return this.http(fn.apply(new NodeInfoHttp.Builder()).build());
        }

        @Nonnull
        public final Builder ingest(@Nullable NodeInfoIngest value) {
            this.ingest = value;
            return this;
        }

        @Nonnull
        public final Builder ingest(Function<NodeInfoIngest.Builder, ObjectBuilder<NodeInfoIngest>> fn) {
            return this.ingest(fn.apply(new NodeInfoIngest.Builder()).build());
        }

        @Nonnull
        public final Builder ip(@Nullable String value) {
            this.ip = value;
            return this;
        }

        @Nonnull
        public final Builder jvm(@Nullable NodeJvmInfo value) {
            this.jvm = value;
            return this;
        }

        @Nonnull
        public final Builder jvm(Function<NodeJvmInfo.Builder, ObjectBuilder<NodeJvmInfo>> fn) {
            return this.jvm(fn.apply(new NodeJvmInfo.Builder()).build());
        }

        @Nonnull
        public final Builder modules(List<PluginStats> list) {
            this.modules = Builder._listAddAll(this.modules, list);
            return this;
        }

        @Nonnull
        public final Builder modules(PluginStats value, PluginStats ... values) {
            this.modules = Builder._listAdd(this.modules, value, values);
            return this;
        }

        @Nonnull
        public final Builder modules(Function<PluginStats.Builder, ObjectBuilder<PluginStats>> fn) {
            return this.modules(fn.apply(new PluginStats.Builder()).build(), new PluginStats[0]);
        }

        @Nonnull
        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder network(@Nullable NodeInfoNetwork value) {
            this.network = value;
            return this;
        }

        @Nonnull
        public final Builder network(Function<NodeInfoNetwork.Builder, ObjectBuilder<NodeInfoNetwork>> fn) {
            return this.network(fn.apply(new NodeInfoNetwork.Builder()).build());
        }

        @Nonnull
        public final Builder os(@Nullable NodeOperatingSystemInfo value) {
            this.os = value;
            return this;
        }

        @Nonnull
        public final Builder os(Function<NodeOperatingSystemInfo.Builder, ObjectBuilder<NodeOperatingSystemInfo>> fn) {
            return this.os(fn.apply(new NodeOperatingSystemInfo.Builder()).build());
        }

        @Nonnull
        public final Builder plugins(List<PluginStats> list) {
            this.plugins = Builder._listAddAll(this.plugins, list);
            return this;
        }

        @Nonnull
        public final Builder plugins(PluginStats value, PluginStats ... values) {
            this.plugins = Builder._listAdd(this.plugins, value, values);
            return this;
        }

        @Nonnull
        public final Builder plugins(Function<PluginStats.Builder, ObjectBuilder<PluginStats>> fn) {
            return this.plugins(fn.apply(new PluginStats.Builder()).build(), new PluginStats[0]);
        }

        @Nonnull
        public final Builder process(@Nullable NodeProcessInfo value) {
            this.process = value;
            return this;
        }

        @Nonnull
        public final Builder process(Function<NodeProcessInfo.Builder, ObjectBuilder<NodeProcessInfo>> fn) {
            return this.process(fn.apply(new NodeProcessInfo.Builder()).build());
        }

        @Nonnull
        public final Builder roles(List<NodeRole> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        @Nonnull
        public final Builder roles(NodeRole value, NodeRole ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        @Nonnull
        public final Builder searchPipelines(@Nullable NodeInfoSearchPipelines value) {
            this.searchPipelines = value;
            return this;
        }

        @Nonnull
        public final Builder searchPipelines(Function<NodeInfoSearchPipelines.Builder, ObjectBuilder<NodeInfoSearchPipelines>> fn) {
            return this.searchPipelines(fn.apply(new NodeInfoSearchPipelines.Builder()).build());
        }

        @Nonnull
        public final Builder settings(@Nullable NodeInfoSettings value) {
            this.settings = value;
            return this;
        }

        @Nonnull
        public final Builder settings(Function<NodeInfoSettings.Builder, ObjectBuilder<NodeInfoSettings>> fn) {
            return this.settings(fn.apply(new NodeInfoSettings.Builder()).build());
        }

        @Nonnull
        public final Builder threadPool(Map<String, NodeThreadPoolInfo> map) {
            this.threadPool = Builder._mapPutAll(this.threadPool, map);
            return this;
        }

        @Nonnull
        public final Builder threadPool(String key, NodeThreadPoolInfo value) {
            this.threadPool = Builder._mapPut(this.threadPool, key, value);
            return this;
        }

        @Nonnull
        public final Builder threadPool(String key, Function<NodeThreadPoolInfo.Builder, ObjectBuilder<NodeThreadPoolInfo>> fn) {
            return this.threadPool(key, fn.apply(new NodeThreadPoolInfo.Builder()).build());
        }

        @Nonnull
        public final Builder totalIndexingBuffer(@Nullable JsonData value) {
            this.totalIndexingBuffer = value;
            return this;
        }

        @Nonnull
        public final Builder totalIndexingBufferInBytes(@Nullable JsonData value) {
            this.totalIndexingBufferInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder transport(@Nullable NodeInfoTransport value) {
            this.transport = value;
            return this;
        }

        @Nonnull
        public final Builder transport(Function<NodeInfoTransport.Builder, ObjectBuilder<NodeInfoTransport>> fn) {
            return this.transport(fn.apply(new NodeInfoTransport.Builder()).build());
        }

        @Nonnull
        public final Builder transportAddress(@Nullable String value) {
            this.transportAddress = value;
            return this;
        }

        @Nonnull
        public final Builder version(String value) {
            this.version = value;
            return this;
        }

        @Override
        @Nonnull
        public NodeInfo build() {
            this._checkSingleUse();
            return new NodeInfo(this);
        }
    }
}

