/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.document;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.document.EnhancedDocument;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.ConverterProviderResolver;
import software.amazon.awssdk.enhanced.dynamodb.internal.document.DefaultEnhancedDocument;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticTableMetadata;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkPublicApi
public final class DocumentTableSchema
implements TableSchema<EnhancedDocument> {
    private final TableMetadata tableMetadata;
    private final List<AttributeConverterProvider> attributeConverterProviders;

    private DocumentTableSchema(Builder builder) {
        this.attributeConverterProviders = builder.attributeConverterProviders;
        this.tableMetadata = builder.staticTableMetaDataBuilder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public EnhancedDocument mapToItem(Map<String, AttributeValue> attributeMap) {
        if (attributeMap == null) {
            return null;
        }
        DefaultEnhancedDocument.DefaultBuilder builder = (DefaultEnhancedDocument.DefaultBuilder)DefaultEnhancedDocument.builder();
        attributeMap.forEach(builder::putObject);
        return builder.attributeConverterProviders(this.attributeConverterProviders).build();
    }

    @Override
    public Map<String, AttributeValue> itemToMap(EnhancedDocument item, boolean ignoreNulls) {
        if (item == null) {
            return null;
        }
        List<AttributeConverterProvider> providers = this.mergeAttributeConverterProviders(item);
        return item.toBuilder().attributeConverterProviders(providers).build().toMap();
    }

    private List<AttributeConverterProvider> mergeAttributeConverterProviders(EnhancedDocument item) {
        if (item.attributeConverterProviders() != null && !item.attributeConverterProviders().isEmpty()) {
            LinkedHashSet<AttributeConverterProvider> providers = new LinkedHashSet<AttributeConverterProvider>();
            providers.addAll(item.attributeConverterProviders());
            providers.addAll(this.attributeConverterProviders);
            return providers.stream().collect(Collectors.toList());
        }
        return this.attributeConverterProviders;
    }

    @Override
    public Map<String, AttributeValue> itemToMap(EnhancedDocument item, Collection<String> attributes) {
        if (item.toMap() == null) {
            return null;
        }
        List<AttributeConverterProvider> providers = this.mergeAttributeConverterProviders(item);
        return item.toBuilder().attributeConverterProviders(providers).build().toMap().entrySet().stream().filter(entry -> attributes.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (left, right) -> left, LinkedHashMap::new));
    }

    @Override
    public AttributeValue attributeValue(EnhancedDocument item, String attributeName) {
        if (item == null) {
            return null;
        }
        List<AttributeConverterProvider> providers = this.mergeAttributeConverterProviders(item);
        return item.toBuilder().attributeConverterProviders(providers).build().toMap().get(attributeName);
    }

    @Override
    public TableMetadata tableMetadata() {
        return this.tableMetadata;
    }

    @Override
    public EnhancedType<EnhancedDocument> itemType() {
        return EnhancedType.of(EnhancedDocument.class);
    }

    @Override
    public List<String> attributeNames() {
        return this.tableMetadata.keyAttributes().stream().map(key -> key.name()).collect(Collectors.toList());
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @NotThreadSafe
    public static final class Builder {
        private final StaticTableMetadata.Builder staticTableMetaDataBuilder = StaticTableMetadata.builder();
        private List<AttributeConverterProvider> attributeConverterProviders = Collections.singletonList(ConverterProviderResolver.defaultConverterProvider());

        public Builder addIndexPartitionKey(String indexName, String attributeName, AttributeValueType attributeValueType) {
            this.staticTableMetaDataBuilder.addIndexPartitionKey(indexName, attributeName, attributeValueType);
            return this;
        }

        public Builder addIndexSortKey(String indexName, String attributeName, AttributeValueType attributeValueType) {
            this.staticTableMetaDataBuilder.addIndexSortKey(indexName, attributeName, attributeValueType);
            return this;
        }

        public Builder attributeConverterProviders(AttributeConverterProvider ... attributeConverterProviders) {
            this.attributeConverterProviders = Arrays.asList(attributeConverterProviders);
            return this;
        }

        public Builder attributeConverterProviders(List<AttributeConverterProvider> attributeConverterProviders) {
            this.attributeConverterProviders = new ArrayList<AttributeConverterProvider>(attributeConverterProviders);
            return this;
        }

        public DocumentTableSchema build() {
            return new DocumentTableSchema(this);
        }
    }
}

