/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage;

import java.util.Map;
import java.util.stream.Stream;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ClientScopeProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.storage.AbstractStorageManager;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.clientscope.ClientScopeLookupProvider;
import org.keycloak.storage.clientscope.ClientScopeStorageProvider;
import org.keycloak.storage.clientscope.ClientScopeStorageProviderFactory;
import org.keycloak.storage.clientscope.ClientScopeStorageProviderModel;

public class ClientScopeStorageManager
extends AbstractStorageManager<ClientScopeStorageProvider, ClientScopeStorageProviderModel>
implements ClientScopeProvider {
    public ClientScopeStorageManager(KeycloakSession session) {
        super(session, ClientScopeStorageProviderFactory.class, ClientScopeStorageProvider.class, ClientScopeStorageProviderModel::new, "clientscope");
    }

    private ClientScopeProvider localStorage() {
        return (ClientScopeProvider)this.session.getProvider(ClientScopeProvider.class);
    }

    public ClientScopeModel getClientScopeById(RealmModel realm, String id) {
        StorageId storageId = new StorageId(id);
        if (storageId.getProviderId() == null) {
            return this.localStorage().getClientScopeById(realm, id);
        }
        ClientScopeLookupProvider provider = (ClientScopeLookupProvider)this.getStorageProviderInstance(realm, storageId.getProviderId(), ClientScopeLookupProvider.class);
        if (provider == null) {
            return null;
        }
        return provider.getClientScopeById(realm, id);
    }

    public Stream<ClientScopeModel> getClientScopesStream(RealmModel realm) {
        return this.localStorage().getClientScopesStream(realm);
    }

    public ClientScopeModel addClientScope(RealmModel realm, String id, String name) {
        return this.localStorage().addClientScope(realm, id, name);
    }

    public boolean removeClientScope(RealmModel realm, String id) {
        return this.localStorage().removeClientScope(realm, id);
    }

    public void removeClientScopes(RealmModel realm) {
        this.localStorage().removeClientScopes(realm);
    }

    public Stream<ClientScopeModel> getClientScopesByProtocol(RealmModel realm, String protocol) {
        return this.localStorage().getClientScopesByProtocol(realm, protocol);
    }

    public Stream<ClientScopeModel> getClientScopesByAttributes(RealmModel realm, Map<String, String> searchMap, boolean useOr) {
        return this.localStorage().getClientScopesByAttributes(realm, searchMap, useOr);
    }

    public void close() {
    }
}

