/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import liquibase.exception.CustomChangeException;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;

public class JpaUpdate26_4_0_SamlEncryptionAttributes
extends CustomKeycloakTask {
    @Override
    protected String getTaskId() {
        return "Insert legacy encryption attributes in SAML clients";
    }

    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        this.statements.add(this.createInsertQueryForAttribute("saml.encryption.algorithm", "http://www.w3.org/2001/04/xmlenc#aes128-cbc"));
        this.statements.add(this.createInsertQueryForAttribute("saml.encryption.keyAlgorithm", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"));
        this.statements.add(this.createInsertQueryForAttribute("saml.encryption.digestMethod", "http://www.w3.org/2000/09/xmldsig#sha1"));
    }

    private SqlStatement createInsertQueryForAttribute(String attribute, String value) {
        String clientTable = this.getTableName("CLIENT");
        String clientAttributesTable = this.getTableName("CLIENT_ATTRIBUTES");
        return new RawSqlStatement(String.format("INSERT INTO %s (CLIENT_ID,NAME,VALUE) SELECT ID, '%s', '%s' FROM %s WHERE PROTOCOL = 'saml' AND ID NOT IN (SELECT CLIENT_ID FROM %s WHERE NAME = '%s')", clientAttributesTable, attribute, value, clientTable, clientAttributesTable, attribute));
    }
}

