﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/datazone/DataZone_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace DataZone {
namespace Model {

/**
 * <p>The environment configuration parameter.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/EnvironmentConfigurationParameter">AWS
 * API Reference</a></p>
 */
class EnvironmentConfigurationParameter {
 public:
  AWS_DATAZONE_API EnvironmentConfigurationParameter() = default;
  AWS_DATAZONE_API EnvironmentConfigurationParameter(Aws::Utils::Json::JsonView jsonValue);
  AWS_DATAZONE_API EnvironmentConfigurationParameter& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DATAZONE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Specifies whether the environment parameter is editable.</p>
   */
  inline bool GetIsEditable() const { return m_isEditable; }
  inline bool IsEditableHasBeenSet() const { return m_isEditableHasBeenSet; }
  inline void SetIsEditable(bool value) {
    m_isEditableHasBeenSet = true;
    m_isEditable = value;
  }
  inline EnvironmentConfigurationParameter& WithIsEditable(bool value) {
    SetIsEditable(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the environment configuration parameter.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  EnvironmentConfigurationParameter& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The value of the environment configuration parameter.</p>
   */
  inline const Aws::String& GetValue() const { return m_value; }
  inline bool ValueHasBeenSet() const { return m_valueHasBeenSet; }
  template <typename ValueT = Aws::String>
  void SetValue(ValueT&& value) {
    m_valueHasBeenSet = true;
    m_value = std::forward<ValueT>(value);
  }
  template <typename ValueT = Aws::String>
  EnvironmentConfigurationParameter& WithValue(ValueT&& value) {
    SetValue(std::forward<ValueT>(value));
    return *this;
  }
  ///@}
 private:
  bool m_isEditable{false};

  Aws::String m_name;

  Aws::String m_value;
  bool m_isEditableHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_valueHasBeenSet = false;
};

}  // namespace Model
}  // namespace DataZone
}  // namespace Aws
