/***************************************************************************
                          newproject2dlg.cpp  -  description
                             -------------------
    begin                : Fri Oct 29 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : fdupoux@lemel.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "newproject2dlg.h"
#include "kfilereplace.h"
#include <qdatetime.h>
#include <qregexp.h>
#include <kmsgbox.h>
#include <stdlib.h>
#include <stdio.h>

// ===========================================================================================================================
NewProject2Dlg::NewProject2Dlg(QWidget *parent, const char *name) : QDialog(parent,name,true)
{
	initDialog();

	connect(m_btnContinue,SIGNAL(clicked()),this,SLOT(slotContinue()));
 	connect(m_btnCancel,SIGNAL(clicked()),this,SLOT(reject()));
 	connect(m_btnBack,SIGNAL(clicked()),this,SLOT(slotBack()));

	connect(m_checkSizeMin,SIGNAL(clicked()),SLOT(slotSizeMinClicked()));
	connect(m_checkSizeMax,SIGNAL(clicked()),SLOT(slotSizeMaxClicked()));

	connect(m_checkDateMin,SIGNAL(clicked()),SLOT(slotDateMinClicked()));
	connect(m_checkDateMax,SIGNAL(clicked()),SLOT(slotDateMaxClicked()));

	// Initialize controls
	m_editSizeMin -> setEnabled(false);
	m_editSizeMax -> setEnabled(false);
	m_editDateMin -> setEnabled(false);
	m_editDateMax -> setEnabled(false);

}

// ===========================================================================================================================
NewProject2Dlg::~NewProject2Dlg()
{
}

// ===========================================================================================================================
void NewProject2Dlg::slotContinue()
{

	// ================== SIZE OPTIONS ========================
	getMaxFilesSize(&m_bMaxSize, &m_nMaxSize);
	getMinFilesSize(&m_bMinSize, &m_nMinSize);

	// ================== DATE OPTIONS ========================
	QString strMinDate, strMaxDate;
	int nDay, nMonth, nYear;

	m_nTypeOfAccess = m_comboDateRW -> currentItem();
	m_bMinDate = m_checkDateMin -> isChecked();
	m_bMaxDate = m_checkDateMax -> isChecked();
	strMinDate.sprintf("%s", m_editDateMin -> text());
	strMaxDate.sprintf("%s", m_editDateMax -> text());

	// =========================================================

	// Check all the fields are filled
	if ( (m_bMaxSize && *(m_editSizeMax -> text()) == 0)
			|| (m_bMinSize && *(m_editSizeMin -> text()) == 0)
			|| (m_bMinDate && *(m_editDateMin -> text()) == 0)
			|| (m_bMaxDate && *(m_editDateMax -> text()) == 0) )
	{ KMsgBox::message((QWidget *)this, "KFileReplace", i18n("Some edit boxes are empty"), KMsgBox::EXCLAMATION, i18n("Cancel"));
		return ;
	}

	// Check option "Size Min/Max": check MinSize is not greater than MaxSize
	if (m_bMaxSize && m_bMinSize && m_nMaxSize < m_nMinSize)
	{ KMsgBox::message((QWidget *)this, "KFileReplace", i18n("The MINimal size is greater than the MAXimal size."), KMsgBox::EXCLAMATION, i18n("Cancel"));
		return ;
	}

	// Check option "Date Min/Max": check date is Valid
	// Check 2 things: * QRegExp ==> Texte Valide (2/2/4)
	//                 * QDate::isValid()

	// 1. Check the first Date: DateMin (After...)
	if (m_bMinDate) // If "DateMin" option in checked
	{	if ( !isDateValid(strMinDate.data()))
		{ KMsgBox::message((QWidget *)this, "KFileReplace", i18n("The dates must be in the DD/MM/AAAA format."), KMsgBox::EXCLAMATION, i18n("Cancel"));
			return ;
		}
	}
			
	// 2. Check the second Date: DateMax (Before...)
	if (m_bMaxDate) // If "DateMax" option in checked
	{	if ( !isDateValid(strMaxDate.data()))
		{ KMsgBox::message((QWidget *)this, "KFileReplace", i18n("The dates must be in the DD/MM/AAAA format."), KMsgBox::EXCLAMATION, i18n("Cancel"));
			return ;
		}
	}

	// 3. Convert Strings to QDate		
	if (m_bMinDate) // If "DateMin" option in checked
	{	sscanf(strMinDate.data(),"%2d/%2d/%4d",&nDay, &nMonth, &nYear);
		m_qdMinDate.setYMD(nYear, nMonth, nDay);
	}

	if (m_bMaxDate) // If "DateMax" option in checked
	{	sscanf(strMaxDate.data(),"%2d/%2d/%4d",&nDay, &nMonth, &nYear);
		m_qdMaxDate.setYMD(nYear, nMonth, nDay);
	}

	// 4. Check DateMax is not before DateMin
	if (m_bMinDate && m_bMaxDate && m_qdMinDate > m_qdMaxDate)
	{ KMsgBox::message((QWidget *)this, "KFileReplace", i18n("The MINimal Date is after the MAXimal Date."), KMsgBox::EXCLAMATION, i18n("Cancel"));
		return ;
	}
	
	accept();
}

// ===========================================================================================================================
void NewProject2Dlg::getMaxFilesSize(bool *bChecked, uint *nMaxSize)
{	*bChecked = m_checkSizeMax -> isChecked();

	if (*bChecked) // If option activated
  	*nMaxSize = atoi(m_editSizeMax -> text()) * 1024; // KB --> Bytes
	else
		*nMaxSize = 0;
}

// ===========================================================================================================================
void NewProject2Dlg::getMinFilesSize(bool *bChecked, uint *nMinSize)
{	*bChecked = m_checkSizeMin -> isChecked();

	if (*bChecked) // If option activated
  	*nMinSize = atoi(m_editSizeMin -> text()) * 1024; // KB --> Bytes
	else
		*nMinSize = 0;
}

// ===========================================================================================================================
void NewProject2Dlg::slotSizeMinClicked()
{ m_editSizeMin -> setEnabled(m_checkSizeMin -> isChecked() == TRUE);
}

// ===========================================================================================================================
void NewProject2Dlg::slotSizeMaxClicked()
{ m_editSizeMax -> setEnabled(m_checkSizeMax -> isChecked() == TRUE);
}

// ===========================================================================================================================
void NewProject2Dlg::slotDateMinClicked()
{	bool bEnabled = (m_checkDateMin -> isChecked() == TRUE);
	m_editDateMin -> setEnabled(bEnabled);
}

// ===========================================================================================================================
void NewProject2Dlg::slotDateMaxClicked()
{	bool bEnabled = (m_checkDateMax -> isChecked() == TRUE);
	m_editDateMax -> setEnabled(bEnabled);
}

// ===========================================================================================================================
void NewProject2Dlg::slotBack()
{
	done(2);
}

// ===========================================================================================================================
bool NewProject2Dlg::isDateValid(char *szDate)
{	QRegExp qreDate("[0-9][0-9]?[/][0-9][0-9]?[/][0-9][0-9][0-9][0-9]");
	int nDay, nMonth, nYear;
	QDate qdDate;

	// a. Check the string is not empty, and the lenght is 2+1+2+1+4 = 10
	if (strlen(szDate) != 10)
		return false;

	// b. Check the format of the string: DD/MM/AAAA
	if (qreDate.match(szDate) != 0)
  	return false;

	// c. Check the date is valid (ex: 32/13/1999 is not valid)
	
	// Convert String to QDate
  sscanf(szDate, "%2d/%2d/%4d", &nDay, &nMonth, &nYear);
  qdDate.setYMD(nYear, nMonth, nDay);
	if (! qdDate.isValid() )
		return false;

	return true;
}

