/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#ifndef SETTINGS_H
#define SETTINGS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qstring.h>
#include <qstringlist.h>

enum Encoding{Locale,UTF8,UTF16};
enum SearchMode{CatalogSearch,AuxiliarySearch,CompendiumSearch};
enum DateFormat{Default,Local,Custom};

struct SaveSettings
{
    bool autoUpdate;
    bool updateLastTranslator;
    bool updateRevisionDate;
    bool updateLanguageTeam;
    bool updateCharset;
    bool updateEncoding;

    Encoding encoding;

    DateFormat dateFormat;
    QString customDateFormat;

    bool autoSyntaxCheck;
};

struct IdentitySettings
{
    QString authorName;
    QString authorEmail;
    QString languageName;
    QString mailingList;
    QString timeZone;
};

struct SearchSettings
{
   bool autoSearch;
   SearchMode defaultMode;

   bool caseSensitive;
   bool ignoreAmpersand;
   bool ignoreNewline;
   bool ignoreDots;
   bool ignoreOther;
   bool exact;
   bool contains;
   bool isContained;

   QString otherIgnores;
   QString moPath;
   QString compendium;
   QString auxiliary;

   QString language;
};

struct EditorSettings
{
   bool autoUnsetFuzzy;
};


/** settings of the CatalogManager */
struct CatManSettings
{
   QString poBaseDir;
   QString potBaseDir;

   bool openWindow;

   QStringList dirCommands;
   QStringList dirCommandNames;
   QStringList fileCommands;
   QStringList fileCommandNames;

   bool killCmdOnExit;
};


/**
* This namespace provides static methods and variables to get the default
* values of configuration values
*/
namespace Defaults
{
   /**
   * this class contains or computes the defaults values of the
   * Save preferences
   */
   class Save
   {
    public:
       static const bool autoUpdate=true;
       static const bool updateLastTranslator=true;
       static const bool updateRevisionDate=true;
       static const bool updateLanguageTeam=true;
       static const bool updateCharset=true;
       static const bool updateEncoding=true;

       static const Encoding encoding=Locale;

       static const DateFormat dateFormat=Default;
       static const QString customDateFormat;

       static const bool autoSyntaxCheck=true;
   };

   class Identity
   {
    public:
       static QString authorName();
       static QString authorEmail();
       static QString languageName();
       static QString mailingList();
       static QString timezone();

    private:
       static QString _authorName;
       static QString _authorEmail;
       static QString _mailingList;
       static QString _timezone;
       static QString _languageName;
   };

   class  Editor
   {
    public:
       static  const bool autoUnsetFuzzy=true;
   };


   class Search
   {
    public:
       static const bool autoSearch=false;
       static const SearchMode defaultMode=CompendiumSearch;

       static const bool caseSensitive=false;
       static const bool ignoreAmpersand=true;
       static const bool ignoreNewline=true;
       static const bool ignoreDots=true;
       static const bool ignoreOther=false;
       static const bool exact=true;
       static const bool contains=true;
       static const bool isContained=true;

       static const QString otherIgnores;
       static const QString moPath;
       static const QString compendium;
       static const QString auxiliary;

       static QString defaultLanguage();
    private:
       static QString _defaultLanguage;
   };

   class CatalogManager
   {
    public:
       static QString poBaseDir();
       static QString potBaseDir();
       static const bool openWindow=false;

       static QStringList dirCommands();
       static QStringList dirCommandNames();
       static QStringList fileCommands();
       static QStringList fileCommandNames();

       static const bool killCmdOnExit=true;

    private:
       static QString _poBaseDir;
       static QString _potBaseDir;
   };
}


#endif // SETTINGS_H
