/***************************************************************************
                          splinedlg.cpp  -  description
                             -------------------
    begin                : Sun Mar 3 2002
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcombobox.h>
#include <qfile.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <kapp.h>
#include <kcolorbtn.h>
#include <klocale.h>
#include <kmessagebox.h>
#include "brushdlg.h"
#include "kpldoc.h"
#include "kpldoubleedit.h"
#include "kplspinbox.h"
#include "rootdlg.h"
#include "splinedlg.h"
#include "splineitem.h"
#include "symboldlg.h"

SplineDlg::SplineDlg(QWidget* _parent, KplDoc* model, SplineItem* fd0) :
 KDialogBase(Plain, i18n("Smoothing spline"),
             Help | Ok | Apply | Cancel | User1 | User2, Ok, _parent, 0,
             true, false, i18n("&Export"), i18n("&Roots")),
 m(model), fd(fd0)
{
  QFrame* frame = plainPage();
  QVBoxLayout* vbox = new QVBoxLayout(frame, 0, spacingHint());
  QGroupBox* g = new QGroupBox(0, Qt::Vertical, i18n("Output"), frame);
  vbox->addWidget(g);
  QHBoxLayout* hbox = new QHBoxLayout(g->layout(), spacingHint());
  hbox->addWidget(eDeriv = new QComboBox(false, g));
  QStringList list;
  list << i18n("Integral") << i18n("Spline") << i18n("1st derivative")
       << i18n("2nd derivative") << i18n("3rd derivative")
       << i18n("4th derivative") << i18n("5th derivative");
  for (int i = 0; i <= fd->kdeg + 1; i++)
    eDeriv->insertItem(list[i]);
  eDeriv->setCurrentItem(fd->nderiv + 1);
  hbox->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding));
  hbox->addWidget(new QLabel(i18n("Lower boundary"), g));
  char frm = m->options()->format;
  int prec = m->options()->prec;
  hbox->addWidget(exLow = new KplDoubleEdit(fd->xlow, g, frm, prec));
  int w = exLow->fontMetrics().width(m->number(-1.0e-123 / 3.0)) + 3;
  exLow->setMinimumWidth(w);
  exLow->setEnabled(fd->nderiv == -1);
  connect(eDeriv, SIGNAL(activated(int)), SLOT(slotDerivChanged(int)));
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Range"), frame));
  QGridLayout* grid = new QGridLayout(g->layout(), 3, 5, spacingHint());
  grid->addWidget(new QLabel("xmin", g), 0, 0);
  grid->addWidget(exMin = new KplDoubleEdit(fd->xmin, g, frm, prec), 0, 1);
  exMin->setMinimumWidth(w);
  grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 2);
  grid->addWidget(new QLabel("xmax", g), 0, 3);
  grid->addWidget(exMax = new KplDoubleEdit(fd->xmax, g, frm, prec), 0, 4);
  exMax->setMinimumWidth(w);
#if KDE_VERSION_MAJOR > 2
  grid->addWidget(new QLabel(QString::fromUtf8("\316\224x"), g), 1, 0);
#else
  grid->addLayout(hbox = new QHBoxLayout(1), 1, 0);
  QLabel* l = new QLabel("D", g);
  l->setFont(QFont("Symbol", 12, QFont::Normal, false, QFont::AnyCharSet));
  hbox->addWidget(l);
  hbox->addWidget(new QLabel("x", g));
  hbox->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding));
#endif
  grid->addWidget(exStep = new KplDoubleEdit(fd->dx, g, frm, prec), 1, 1);
  exStep->setMinimumWidth(w);
  grid->addWidget(new QLabel(i18n("x normalization"), g), 2, 0);
  grid->addWidget(efx = new KplDoubleEdit(fd->fx, g), 2, 1);
  grid->addWidget(new QLabel(i18n("y normalization"), g), 2, 3);
  grid->addWidget(efy = new KplDoubleEdit(fd->fy, g), 2, 4);
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Representation"),
                                    frame));
  grid = new QGridLayout(g->layout(), 2, 6, spacingHint());
  grid->addWidget(new QLabel(i18n("Symbol"), g), 0, 0);
  grid->addWidget(symb = new KplSpinBox(-17, 9, 1, g), 0, 1);
  symb->setValue(fd->symb);
  grid->addWidget(new SymbolButton(g, symb), 0, 2);
  grid->addWidget(new QLabel(i18n("Color"), g), 0, 4);
  grid->addWidget(colData = new KColorButton(fd->color, g), 0, 5);
  colData->setMinimumWidth(50);
  grid->addWidget(new QLabel(i18n("Size"), g), 1, 0);
  grid->addWidget(eRelSize = new KplSpinBox(10, 800, 1, g), 1, 1);
  eRelSize->setValue(qRound(100 * fd->relsiz));
  eRelSize->setSuffix(" %");
  grid->addWidget(new QLabel(i18n("Fill pattern"), g), 1, 4);
  grid->addWidget(fill = new BrushButton(g, fd->fillStyle), 1, 5);
  setHelp("SEC-SPLINE");
  enableButton(User2, fd->nk && (fd->kdeg == 3));
  resize(minimumSize());
}

SplineDlg::~SplineDlg()
{
}

void SplineDlg::getTemp(SplineItem* fdt)
{
  fdt->nderiv = eDeriv->currentItem() - 1;
  fdt->fx = efx->value();
  fdt->fy = efy->value();
  fdt->xmin = exMin->value();
  fdt->xmax = exMax->value();
  fdt->dx = exStep->value();
  fdt->xlow = exLow->value();
  fdt->color = colData->color().rgb();
  fdt->symb = symb->interpretedValue();
  fdt->relsiz = 0.01 * eRelSize->interpretedValue();
  fdt->fillStyle = fill->value();
}

void SplineDlg::getValues(bool ok)
{
  getTemp(fd);
  m->setModified();
  m->backupItems();
  if (ok)
    accept();
}

void SplineDlg::slotDerivChanged(int index)
{
  exLow->setEnabled(!index);
}

void SplineDlg::slotUser1()
{
  SplineItem fdt(*fd);
  getTemp(&fdt);
  KURL url;
  if (m->getWriteURL(this, url, "*.dat\n*")) {
    QFile f(url.isLocalFile() ? url.path() : m->tmpFile());
    if (f.open(IO_WriteOnly)) {
      QTextStream ts(&f);
      fdt.exportTable(ts, m);
      f.close();
      m->setCurrentDir(url);
      if (!url.isLocalFile())
        m->copyTmp(f.name(), url);
    } else
      KMessageBox::error(this, i18n("while trying to open"));
  }
}

void SplineDlg::slotUser2()
{
  RootDlg dlg(this, m, fd);
  dlg.exec();
}

void SplineDlg::slotOk()
{
  getValues(true);
}

void SplineDlg::slotApply()
{
  getValues(false);
}
