/***************************************************************************
                          arcdlg.cpp  -  description
                             -------------------
    begin                : Sat Aug 17 2002
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <klocale.h>
#include "kpldoubleedit.h"
#include "arcitem.h"
#include "arcdlg.h"

ArcDlg::ArcDlg(QWidget* _parent, KplDoc* model, ArcItem* ad0) :
 DecoDlg(_parent, i18n("Arc"), "SEC-ARC", model, ad0, 5), ad(ad0)
{
  setCaption(i18n("Arc"));
  QFrame* frame = plainPage();
  grid->addWidget(new QLabel(i18n("Width"), frame), 0, 0);
  grid->addWidget(eWidth = new KplDoubleEdit(ad->width, 0.1, 200.0, frame),
                  0, 1);
  grid->addWidget(new QLabel("cm", frame), 0, 2);
  grid->addWidget(new QLabel(i18n("Height"), frame), 0, 4);
  grid->addWidget(eHeight = new KplDoubleEdit(ad->height, 0.1, 200.0, frame),
                  0, 5);
  grid->addWidget(new QLabel("cm", frame), 0, 6);
  grid->addWidget(new QLabel(i18n("Start"), frame), 1, 0);
  grid->addWidget(eA = new KplDoubleEdit(ad->a, -360.0, 360.0, frame),
                  1, 1);
  grid->addWidget(new QLabel("", frame), 1, 2);
  grid->addWidget(new QLabel(i18n("Length"), frame), 1, 4);
  grid->addWidget(eAlen = new KplDoubleEdit(ad->alen, -360.0, 360.0, frame),
                  1, 5);
  grid->addWidget(new QLabel("", frame), 1, 6);
  grid->addWidget(new QLabel(i18n("Rotation"), frame), 2, 0);
  grid->addWidget(eDir = new KplDoubleEdit(ad->dir, -360.0, 360.0, frame),
                  2, 1);
  grid->addWidget(new QLabel("", frame), 2, 2);
  initEntries(3);
  lSize->setText(i18n("Line width"));
}

ArcDlg::~ArcDlg()
{
}

void ArcDlg::getValues(bool ok)
{
  ad->width = eWidth->value();
  ad->height = eHeight->value();
  ad->dir = eDir->value();
  ad->a = eA->value();
  ad->alen = eAlen->value();
  DecoDlg::getValues(ok);
}

void ArcDlg::slotOk()
{
  getValues(true);
}

void ArcDlg::slotApply()
{
  getValues(false);
}
