/***************************************************************************
                          basicdlg.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2003 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qgroupbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <klocale.h>
#include <kcolorbtn.h>
#include <kglobal.h>
#include "basicdlg.h"
#include "kpldoubleedit.h"
#include "kplspinbox.h"
#include "utils.h"

const double BasicDlg::xSize[] = {29.7, 42.0, 21.0, 29.7, 14.8, 21.0,
                                  21.59, 27.94};
const double BasicDlg::ySize[] = {42.0, 29.7, 29.7, 21.0, 21.0, 14.8,
                                  27.94, 21.59};

BasicDlg::BasicDlg(QWidget* _parent, Kpl::AutoStruct* bs) :
 KDialogBase(Plain, i18n("Basic settings"), Help | Ok | Cancel, Ok, _parent),
 b(bs)
{
  QFrame* frame = plainPage();
  QVBoxLayout* vbox = new QVBoxLayout(frame, 0, spacingHint());
  QGroupBox* g = new QGroupBox(0, Qt::Vertical, i18n("Page format "), frame);
  vbox->addWidget(g);
  QVBoxLayout* vbox2 = new QVBoxLayout(g->layout(), spacingHint());
  vbox2->addWidget(format = new QComboBox(false, g));
  QStringList list;
  list << i18n("Portrait A3") << i18n("Landscape A3")
       << i18n("Portrait A4") << i18n("Landscape A4")
       << i18n("Portrait A5") << i18n("Landscape A5")
       << i18n("Portrait Letter") << i18n("Landscape Letter")
       << i18n("Custom");
  format->insertStringList(list);
  QHBoxLayout* hbox = new QHBoxLayout(vbox2, spacingHint());
  hbox->addWidget(new QLabel(i18n("Width"), g));
  hbox->addWidget(formatx = new KplDoubleEdit(b->xf, 0.5, 200.0, g));
  hbox->addWidget(new QLabel("cm", g));
  hbox->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding));
  hbox->addWidget(new QLabel(i18n("Height"), g));
  hbox->addWidget(formaty = new KplDoubleEdit(b->yf, 0.5, 200.0, g));
  hbox->addWidget(new QLabel("cm", g));
  int i;
  lFormat = sizeof(xSize) / sizeof(double);
  for (i = 0; i < lFormat; i++)
    if ((xSize[i] == b->xf) && (ySize[i] == b->yf)) {
      formatx->setEnabled(false);
      formaty->setEnabled(false);
      break;
    }
  format->setCurrentItem(i);
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Default colors"),
                                    frame));
  QGridLayout* grid = new QGridLayout(g->layout(), 3, 3, spacingHint());
  grid->addWidget(new QLabel(i18n("Frame"), g), 0, 0);
  grid->addWidget(colFrame = new KColorButton(QColor(b->colFrame), g),
                  0, 1);
  grid->addWidget(new QLabel(i18n("Grid"), g), 1, 0);
  grid->addWidget(colGrid = new KColorButton(QColor(b->colGrid), g), 1, 1);
  grid->addWidget(new QLabel(i18n("Data"), g), 2, 0);
  grid->addWidget(colData = new KColorButton(QColor(b->colData), g), 2, 1);
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Output format"),
                                    frame));
  grid = new QGridLayout(g->layout(), 3, 3, spacingHint());
  grid->addWidget(new QLabel(i18n("Presentation"), g), 0, 0);
  grid->addWidget(pres = new QComboBox(true, g), 0, 1);
  const char* items[] = {"e", "E", "f", "g", "G", 0};
  pres->insertStrList(items);
  for (i = 0; i < 5; i++)
    if (*items[i] == b->format)
      break;
  pres->setCurrentItem(i);
  grid->addWidget(new QLabel(i18n("Precision"), g), 1, 0);
  grid->addWidget(prec = new KplSpinBox(0, 0, 1, g), 1, 1);
  prec->setRange(1, 30);
  prec->setValue(b->prec);
  grid->addWidget(sep = new QComboBox(false, g), 2, 1);
  list.clear();
  list << i18n("Space") << i18n("Tab") << ",";
  sep->insertStringList(list);
  sep->setCurrentItem(b->iSep);
  grid->addWidget(new QLabel(sep, i18n("&Separator"), g), 2, 0);
  Utils::setSize(this, "BasicDialog");
  setHelp("SEC-BASIC");
  connect(format, SIGNAL(activated(int)), SLOT(slotFormatChanged(int)));
}

BasicDlg::~BasicDlg()
{
  Utils::saveSize(this, "BasicDialog");
}

void BasicDlg::slotFormatChanged(int i)
{
  bool standard = (i < lFormat);
  formatx->setDisabled(standard);
  formaty->setDisabled(standard);
  if (standard) {
    formatx->setValue(xSize[i]);
    formaty->setValue(ySize[i]);
  }
}

void BasicDlg::slotOk()
{
  b->xf = formatx->value();
  b->yf = formaty->value();
  b->colFrame = colFrame->color().rgb();
  b->colGrid = colGrid->color().rgb();
  b->colData = colData->color().rgb();
  b->format = *pres->currentText();
  b->prec = prec->interpretedValue();
  b->iSep = sep->currentItem();
  accept();
}
