#ifndef EDITENTRYDIALOG_H
#define EDITENTRYDIALOG_H

/* This file implements the dialog for editing an entry.
 * Declaration
 *
 * the Configuration Database library
 * copyright:  (C) Mirko Sucker, 1998
 * license:    GNU Public License, Version 2
 * mail to:    Mirko Sucker <mirko.sucker@hamburg.netsurf.de>
 *                          <mirko.sucker@unibw-hamburg.de>
 * requires:   C++-compiler, STL, string class, Qt
 *             NANA (for debugging)
 * $Revision: 1.1 $
 */

#include <qtabdlg.h>
#include <qdialog.h>
#include <qlined.h>
#include <qmlined.h> 
#include <qpushbt.h>
#include "addressbook.h"
#include "datepickerdialog.h"

class EditEntryDialog : public QDialog
{
  Q_OBJECT
public:
  EditEntryDialog(QWidget* parent=0, const char* name=0);
  AddressBook::Entry getEntry();
  void setEntry(const AddressBook::Entry&);
protected:
  // the tab dialog itselfs
  QTabDialog* dialog;
  // the "name" tab
  QLineEdit *leTitle, *leFirstName, *leAddName, 
    *leName, *leFormattedName, 
    *leAddress, *leTown;
  // the "organization" tab
  QLineEdit *leOrg, *leRole, *leOrgUnit, *leOrgSubUnit;
  // the "contact" tab
  QLineEdit *leEmail1, *leEmail2, *leEmail3,
    *leTelephone, *leFax, *leModem, *leURL;
  // the "others" tab
  QMultiLineEdit* mleComment;
  DateLabel* dlBirthDay;
  QPushButton* pbTalk;
  // ------
  AddressBook::Entry entry;
  // ------
  void createTabs();
public slots:
  void okPressed();
  void cancelPressed();
  void editTalkAddresses();
};

#endif // EDITENTRYDIALOG_H

