/* This file implements the dialog for editing an entry.
 * Implementation
 *
 * the Configuration Database library
 * copyright:  (C) Mirko Sucker, 1998
 * license:    GNU Public License, Version 2
 * mail to:    Mirko Sucker <mirko.sucker@hamburg.netsurf.de>
 *                          <mirko.sucker@unibw-hamburg.de>
 * requires:   C++-compiler, STL, string class, Qt
 *             NANA (for debugging)
 * $Revision: 1.1 $
 */

#include "StringListDialog.h"
#include "editentry.h"
#include "widgets.h"
#include "widget.h"
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbt.h>
#include <qmsgbox.h>
#include <qkeycode.h>
#include <kapp.h>
#include "debug.h"

EditEntryDialog::EditEntryDialog(QWidget* parent, 
				 const char* name)
  : QDialog(parent, name, true)
{
  ID(bool GUARD=false);
  // ########################################################
  LG(GUARD, "EditEntryDialog constructor: "
     "creating dialog.\n");
  dialog=new QTabDialog(this);
  dialog->setCancelButton();
  // ------
  connect(dialog, SIGNAL(applyButtonPressed()),
  	  SLOT(okPressed()));
  connect(dialog, SIGNAL(cancelButtonPressed()),
	  SLOT(cancelPressed()));
  // ------
  createTabs();
  dialog->move(0, 0);
  LG(GUARD, "EditEntryDialog constructor: tab dialog has "
     "size %ix%i.\n", dialog->width(), dialog->height());
  setFixedSize(dialog->width(), dialog->height());
  setCaption(i18n("Edit the current entry"));
  // ########################################################
  LG(GUARD, "EditEntryDialog constructor: done.\n");
}

void EditEntryDialog::createTabs()
{
  ID(bool GUARD=false);
  // ########################################################
  LG(GUARD, "EditEntryDialog::createTabs: "
     "creating tabbed dialog.\n");
  QLabel* label;
  QWidget *name, *org, *contact, *others;
  int count, x, y;
  int widestTab=0;
  int highestTab=0;
  const int Border=5;
  // ------  
  // a tab for the basics: title, name, firstname, 
  // additional name, formatted name
  LG(GUARD, "EditEntryDialog::createTabs:"
     " creating name tab.\n");
  {
    QGridLayout *layout;
    int widestString=0;
    const char* labels[]= { 
      i18n("Title:"), 
      i18n("First name:"), 	    
      i18n("Additional Name:"), 
      i18n("Name:"),
      i18n("Formatted Name:"),
      i18n("Address:"),
      i18n("Town:") };
    QLineEdit** ledits[]= {
      &leTitle,
      &leFirstName,
      &leAddName,
      &leName,
      &leFormattedName,
      &leAddress,
      &leTown };
    const int Size=sizeof(labels)/sizeof(labels[0]);
    CHECK(Size==sizeof(ledits)/sizeof(ledits[0]));
    name=new QWidget(dialog);
    layout=new QGridLayout(name, Size, 2, Border);
    layout->setColStretch(0, 1);
    layout->setColStretch(1, 2);
    for(count=0; count<Size; count++)
      {
	label=new QLabel(labels[count], name);
	// find the needed space:
	y=label->fontMetrics().width(labels[count]);
	if(widestString<y) widestString=y;
	*ledits[count]=new QLineEdit(name);
	layout->addWidget(label, count, 0);
	layout->addWidget(*ledits[count], count, 1);
      }  
    dialog->addTab(name, i18n("&Name"));
    y=(Size+1)*Border
      +Size*((*ledits[0])->sizeHint().height());
    if(y>highestTab) highestTab=y;
    x=3*Border+3*widestString; // see column stretch factors
    if(x>widestTab) widestTab=x;
    layout->activate();
    name->setFixedHeight(y);
    LG(GUARD, "EditEntryDialog::createTabs: "
       "finished, %ix%i pixels.\n", x, y);
  }
  // end of first tab "&Name"
  // ------
  // a tab for the organizational data
  LG(GUARD, "EditEntryDialog::createTabs: "
     "creating org tab.\n");
  {
    QGridLayout *layout;
    int widestString=0;
    const char* labels[]= {
      i18n("Organization:"),
      i18n("Role:"),
      i18n("Org Unit:"),
      i18n("Org Subunit:") };
    QLineEdit** ledits[]= {
      &leOrg,
      &leRole,
      &leOrgUnit,
      &leOrgSubUnit };
    const int Size=sizeof(labels)/sizeof(labels[0]);
    CHECK(Size==sizeof(ledits)/sizeof(ledits[0]));
    org=new QWidget(dialog);
    layout=new QGridLayout(org, Size, 2, Border);
    layout->setColStretch(0, 1);
    layout->setColStretch(1, 2);     
    for(count=0; count<Size; count++)
      {
	label=new QLabel(labels[count], org);
	y=label->fontMetrics().width(labels[count]);
	if(widestString<y) widestString=y;
	*ledits[count]=new QLineEdit(org);
	layout->addWidget(label, count, 0);
	layout->addWidget(*ledits[count], count, 1);
      }  
    dialog->addTab(org, i18n("&Organization"));
    y=(Size+1)*Border
      +Size*((*ledits[0])->sizeHint().height());
    if(y>highestTab) highestTab=y;
    x=3*Border+3*widestString;
    if(x>widestTab) widestTab=x;
    layout->activate();
    org->setFixedHeight(y);
    LG(GUARD, "EditEntryDialog::createTabs: "
       "finished, %ix%i pixels.\n", x, y);
  }
  // end of "org" tab
  // ------
  // a tab for email addresses, telefon numbers and URLs
  LG(GUARD, "EditEntryDialog::createTabs: "
     "creating contact tab.\n");
  {
    QGridLayout *layout;
    int widestString=0;
    const char* labels[]= {
      i18n("Email address:"),
      i18n("Email address (2):"),
      i18n("Email address (3):"),
      i18n("Telephone:"),
      i18n("Fax:"),
      i18n("Modem:"),
      i18n("Homepage (URL):") };
    QLineEdit** ledits[]= {
      &leEmail1, &leEmail2, 
      &leEmail3, &leTelephone, 
      &leFax, &leModem, &leURL };
    const int Size=sizeof(labels)/sizeof(labels[0]);
    CHECK(Size==sizeof(ledits)/sizeof(ledits[0]));
    contact=new QWidget(dialog);
    layout=new QGridLayout(contact, Size, 2, Border);
    layout->setColStretch(0, 1);
    layout->setColStretch(1, 2);     
    for(count=0; count<Size; count++)
      {
	label=new QLabel(labels[count], contact);
	y=label->fontMetrics().width(labels[count]);
	if(widestString<y) widestString=y;
	*ledits[count]=new QLineEdit(contact);
	layout->addWidget(label, count, 0);
	layout->addWidget(*ledits[count], count, 1);
      }  
    dialog->addTab(contact, i18n("&Contact"));
    y=(Size+1)*Border+Size*((*ledits[0])->sizeHint().height());
    if(y>highestTab) highestTab=y;
    x=3*Border+3*widestString;
    if(x>widestTab) widestTab=x;
    layout->activate();
    contact->setFixedHeight(y);
    LG(GUARD, "EditEntryDialog::createTabs: "
       "finished, %ix%i pixels.\n", x, y);
  }
  // end of tab "&Contact"
  // ------
  // a tab for everything else:
 {
   int widestString=0;
   int x;
   const int noOfRows=3;
   QGridLayout *layout;
   others=new QWidget(dialog);
   layout=new QGridLayout(others, noOfRows, 2, Border);
   layout->setColStretch(0, 1);
   layout->setColStretch(1, 2);     

   label=new QLabel(i18n("Comment:"), others);
   mleComment=new QMultiLineEdit(others);
   layout->addWidget(label, 0, 0);
   layout->addWidget(mleComment, 0, 1);
   y=label->fontMetrics().width(label->text());
   if(y>widestString) widestString=y;
   

   label=new QLabel(i18n("Birthday:"), others);
   dlBirthDay=new DateLabel(others, 0, QDate());
   dlBirthDay->enableChangeDialog(true);

   layout->addWidget(label, 1, 0);
   layout->addWidget(dlBirthDay, 1, 1);   
   y=label->fontMetrics().width(label->text());
   if(y>widestString) widestString=y;

   pbTalk=new QPushButton(others);
   connect(pbTalk, SIGNAL(clicked()),
	   SLOT(editTalkAddresses()));
   pbTalk->setText(i18n("Edit talk addresses"));
   layout->addWidget(pbTalk, 2, 1);

   layout->setRowStretch(0, 5);
   layout->setRowStretch(1, 1);
   layout->setRowStretch(2, 1);

   dialog->addTab(others, i18n("O&thers"));
   layout->activate();
   // careful: leName must be created until here!
   y=7*leName->sizeHint().height()+8*Border;
   others->setFixedHeight(y);
   if(y>highestTab) highestTab=y;
   x=3*Border+3*widestString;
   if(x>widestTab) widestTab=x;
  }
  // ------
  // set the height and width of the tab dialog
  LG(GUARD, "EditEntryDialog::createTabs: finished creating "
     "dialog, resizing to %ix%i pixels.\n", 
     widestTab+30, highestTab+100);
  name->setFixedWidth(widestTab);
  org->setFixedWidth(widestTab);  
  contact->setFixedWidth(widestTab);
  others->setFixedWidth(widestTab);
  dialog->resize(widestTab+30, 
		 highestTab+100); // both values estimated
  // ########################################################
}

void EditEntryDialog::okPressed()
{
  // ########################################################
  // these two arrays contain lineedits and 
  // corresponding string objects:
  string* entries[]= {
    &entry.title,
    &entry.firstname,
    &entry.additionalName,
    &entry.name,
    &entry.fn,
    &entry.address,
    &entry.town,
    &entry.org,
    &entry.orgUnit,
    &entry.orgSubUnit,
    &entry.role,
    &entry.email,
    &entry.email2,
    &entry.email3,
    &entry.telephone,
    &entry.fax,
    &entry.modem,
    &entry.URL };
  QLineEdit* ledits[]= {
    leTitle,
    leFirstName,
    leAddName,
    leName,
    leFormattedName,
    leAddress,
    leTown,
    leOrg,
    leOrgUnit,
    leOrgSubUnit,
    leRole,
    leEmail1,
    leEmail2,
    leEmail3,
    leTelephone,
    leFax,
    leModem,
    leURL };
  const int Size=sizeof(entries)/sizeof(entries[0]);
  int count;
  CHECK(Size==sizeof(ledits)/sizeof(ledits[0]));
  for(count=0; count<Size; count++)
    {
      *entries[count]=ledits[count]->text();
    }
  entry.comment=mleComment->text();
  entry.birthday=dlBirthDay->getDate();
  emit(accept());
  // ########################################################
}

void EditEntryDialog::cancelPressed()
{
  // ########################################################
  emit(reject());
  // ########################################################
}

AddressBook::Entry EditEntryDialog::getEntry()
{
  // ########################################################
  return entry;
  // ########################################################
}

void EditEntryDialog::setEntry(const AddressBook::Entry& data)
{
  // ########################################################
  entry=data;
   // these two arrays contain lineedits and 
  // corresponding string objects:
  const string* entries[]= {
    &data.title,
    &data.firstname,
    &data.additionalName,
    &data.name,
    &data.fn,
    &data.address,
    &data.town,
    &data.org,
    &data.orgUnit,
    &data.orgSubUnit,
    &data.role,
    &data.email,
    &data.email2,
    &data.email3,
    &data.telephone,
    &data.fax,
    &data.modem,
    &data.URL };
  QLineEdit* ledits[]= {
    leTitle,
    leFirstName,
    leAddName,
    leName,
    leFormattedName,
    leAddress,
    leTown,
    leOrg,
    leOrgUnit,
    leOrgSubUnit,
    leRole,
    leEmail1,
    leEmail2,
    leEmail3,
    leTelephone,
    leFax,
    leModem,
    leURL };
  const int Size=sizeof(entries)/sizeof(entries[0]);
  int count;
  CHECK(Size==sizeof(ledits)/sizeof(ledits[0]));
  for(count=0; count<Size; count++)
    {
      ledits[count]->setText((*entries[count]).c_str());
    } 
  mleComment->setText(data.comment.c_str());
  dlBirthDay->setDate(data.birthday);
  // ########################################################
}

void EditEntryDialog::editTalkAddresses()
{
  ID(bool GUARD=false);
  LG(GUARD, "EditEntryDialog::editTalkAddresses: called.\n");
  // ########################################################
  StringListDialog dialog(this);
  dialog.setCaption(i18n("Edit talk addresses"));
  dialog.set(entry.talk);
  if(dialog.exec())
    {
      entry.talk=dialog.get();
    } else {
      qApp->beep();
    }
  // ########################################################
}
// ------
#include "editentry.moc"
