/*
 * Copyright (C) 2004, Mart Kelder (mart.kde@hccnet.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef MK_HVITEM_H
#define MK_HVITEM_H

#include <boxcontaineritem.h>

class KActionCollection;
class KMenu;

class Label;
template< class T > class QList;

/**
 * Item for a horizontal or vertical displayed window.
 */
class HVItem : public BoxContainerItem
{ Q_OBJECT
public:
	/**
	 * Constructor
	 *
	 * @param parent the parent of this object
	 */
	HVItem( QWidget *parent = 0 );
	/**
	 * Destructor
	 */
	~HVItem();
	
	/**
	 * This function calles show() to the label.
	 */
	virtual void showBox();
	
	/**
	 * This function can be used to get the label belonging to this item.
	 * This is for example used to add the label to a layout.
	 *
	 * @return The label of this item
	 */
	QLabel* getLabel() const;
public slots:
	/**
	 * Sets the number of new messages.
	 *
	 * @param count The number of unread messages.
	 * @param newMessages Are there any new messages?
	 */
	void setCount( const int count, const bool newMessages );
	
	/**
	 * This function sets the tooltip @p string to a box.
	 * @param string The tooltip to be added.
	 */
	virtual void setTooltip( const QString& string );
	
	/**
	 * This slot triggered when the passive popup is to be shown. It is transported
	 * to BoxContainerItem, but so it is possible to change the arguments.
	 */
	void slotShowPassivePopup( QList< KornMailSubject >* list, int total, bool date, const QString& );
	
	/**
	 * This slot triggered when the passive popup is to be shown. It is transported
	 * to BoxContainerItem, but so it is possible to change the arguments.
	 */
	void slotShowPassivePopup( const QString& errorMessage, const QString& name );

	/**
	 * Trigered if the popup-menu is to be shown
	 */
	virtual void doPopup();
private:
	Label *_label;
	KMenu *_popup;
	KActionCollection *_actions;
};

#endif //MK_HVITEM_H
