#![Boost.Log](doc/logo.png)

Boost.Log, part of collection of the [Boost C++ Libraries](http://github.com/boostorg), provides tools for adding logging to libraries and applications.

### Directories

* **build** - Boost.Log build scripts
* **config** - Boost.Log build configuration code and scripts
* **doc** - QuickBook documentation sources
* **example** - Boost.Log examples
* **include** - Interface headers of Boost.Log
* **src** - Compilable source code of Boost.Log
* **test** - Boost.Log unit tests

### More information

* [Documentation](http://boost.org/libs/log)
* [Ask questions](http://stackoverflow.com/questions/ask?tags=c%2B%2B,boost,boost-log)
* [Report bugs](https://svn.boost.org/trac/boost/newticket?component=log;version=Boost%20Release%20Branch). Be sure to mention Boost version, platform and compiler you're using. A small compilable code sample to reproduce the problem is always good as well.
* Submit your patches as pull requests against **develop** branch. Note that by submitting patches you agree to license your modifications under the [Boost Software License, Version 1.0](http://www.boost.org/LICENSE_1_0.txt).
* Discussions about the library are held on the [Boost developers mailing list](http://www.boost.org/community/groups.html#main). Be sure to read the [discussion policy](http://www.boost.org/community/policy.html) before posting and add the `[log]` tag at the beginning of the subject line.

### License

Distributed under the [Boost Software License, Version 1.0](http://www.boost.org/LICENSE_1_0.txt).
