/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.hash;

import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.hash.RipeMD128;
import gnu.crypto.util.Util;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

public class TestOfRipeMD128
implements Testlet {
    private IMessageDigest algorithm;
    private IMessageDigest clone;

    public void test(TestHarness harness) {
        String exp;
        byte[] md;
        harness.checkPoint("TestOfRipeMD128");
        try {
            this.algorithm = new RipeMD128();
            harness.check(this.algorithm.selfTest(), "selfTest");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfRipeMD128.selfTest");
        }
        try {
            this.algorithm = new RipeMD128();
            this.algorithm.update("a".getBytes(), 0, 1);
            md = this.algorithm.digest();
            exp = "86BE7AFA339D0FC7CFC785E72F578D33";
            harness.check(exp.equals(Util.toString((byte[])md)), "testA");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfRipeMD128.testA");
        }
        try {
            this.algorithm = new RipeMD128();
            this.algorithm.update("abc".getBytes(), 0, 3);
            md = this.algorithm.digest();
            exp = "C14A12199C66E4BA84636B0F69144C77";
            harness.check(exp.equals(Util.toString((byte[])md)), "testABC");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfRipeMD128.testABC");
        }
        try {
            this.algorithm = new RipeMD128();
            this.algorithm.update("message digest".getBytes(), 0, 14);
            md = this.algorithm.digest();
            exp = "9E327B3D6E523062AFC1132D7DF9D1B8";
            harness.check(exp.equals(Util.toString((byte[])md)), "testMessageDigest");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfRipeMD128.testMessageDigest");
        }
        try {
            this.algorithm = new RipeMD128();
            this.algorithm.update("abcdefghijklmnopqrstuvwxyz".getBytes(), 0, 26);
            md = this.algorithm.digest();
            exp = "FD2AA607F71DC8F510714922B371834E";
            harness.check(exp.equals(Util.toString((byte[])md)), "testAlphabet");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfRipeMD128.testAlphabet");
        }
        try {
            this.algorithm = new RipeMD128();
            this.algorithm.update("a".getBytes(), 0, 1);
            this.clone = (IMessageDigest)this.algorithm.clone();
            md = this.algorithm.digest();
            exp = "86BE7AFA339D0FC7CFC785E72F578D33";
            harness.check(exp.equals(Util.toString((byte[])md)), "testCloning #1");
            this.clone.update("bc".getBytes(), 0, 2);
            md = this.clone.digest();
            exp = "C14A12199C66E4BA84636B0F69144C77";
            harness.check(exp.equals(Util.toString((byte[])md)), "testCloning #2");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfRipeMD128.testCloning");
        }
    }
}

