/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * Represents a block in which a {@link GtkStockItem} can be stored in a {@link
 * TreeModel} (such as {@link ListStore} or {@link TreeStore}).
 * <p>
 * See {@link DataColumn} description for more information.
 * 
 * @author Mark Howard &lt;mh@debian.org&gt;
 */
public class DataColumnStockItem extends DataColumn {

    /**
     * Constructs a new datablock for storing stock items.
     */
    public DataColumnStockItem() {
        type = Type.STRING();
    }

}
