/*
 * Java-Gnome Bindings Library
 *
 * Copyright 2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.glib;

import org.gnu.javagnome.Handle;
import org.gnu.javagnome.Struct;

/**
 * Class for memory management of structs.  Should be renamed to
 * Struct once we rename org.javagnome.Struct to org.javagnome.Proxy.
 */
public class MemStruct extends Struct 
{
    public MemStruct() {}

    public MemStruct( Handle handle ) {
        super( handle );
    }

    public static MemStruct getMemStructFromHandle( Handle handle ) {
        return (MemStruct)handle.getProxiedObject();
    }

    protected void finalize() throws Throwable {
        nativeFinalize(getHandle());
    }

    native static final private void nativeFinalize(Handle handle);

}

