/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef _Included_org_gnu_gtk_FileFilter
#define _Included_org_gnu_gtk_FileFilter
#ifdef __cplusplus
extern "C" {
#endif
/*
 * Class:     org_gnu_gtk_FileFilter
 * Method:    gtk_file_filter_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_FileFilter_gtk_1file_1filter_1get_1type
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_file_filter_get_type();
}

/*
 * Class:     org_gnu_gtk_FileFilter
 * Method:    gtk_file_filter_new
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_FileFilter_gtk_1file_1filter_1new
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_file_filter_new();
}

/*
 * Class:     org_gnu_gtk_FileFilter
 * Method:    gtk_file_filter_set_name
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileFilter_gtk_1file_1filter_1set_1name
  (JNIEnv *env, jclass cls, jint filter, jstring name)
{
	const gchar* n = (*env)->GetStringUTFChars(env, name, NULL);
	gtk_file_filter_set_name((GtkFileFilter*)filter, n);
	(*env)->ReleaseStringUTFChars(env, name, n);
}

/*
 * Class:     org_gnu_gtk_FileFilter
 * Method:    gtk_file_filter_get_name
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_FileFilter_gtk_1file_1filter_1get_1name
  (JNIEnv *env, jclass cls, jint filter)
{
	return (*env)->NewStringUTF(env, (char*)gtk_file_filter_get_name((GtkFileFilter*)filter));
}

/*
 * Class:     org_gnu_gtk_FileFilter
 * Method:    gtk_file_filter_add_mime_type
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileFilter_gtk_1file_1filter_1add_1mime_1type
  (JNIEnv *env, jclass cls, jint filter, jstring mimeType)
{
	const gchar* mt = (*env)->GetStringUTFChars(env, mimeType, NULL);
	gtk_file_filter_add_mime_type((GtkFileFilter*)filter, mt);
	(*env)->ReleaseStringUTFChars(env, mimeType, mt);
}

/*
 * Class:     org_gnu_gtk_FileFilter
 * Method:    gtk_file_filter_add_pattern
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileFilter_gtk_1file_1filter_1add_1pattern
  (JNIEnv *env, jclass cls, jint filter, jstring pattern)
{
	const gchar* p = (*env)->GetStringUTFChars(env, pattern, NULL);
	gtk_file_filter_add_pattern((GtkFileFilter*)filter, p);
	(*env)->ReleaseStringUTFChars(env, pattern, p);
}

/*
 * Class:     org_gnu_gtk_FileFilter
 * Method:    gtk_file_filter_get_needed
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_FileFilter_gtk_1file_1filter_1get_1needed
  (JNIEnv *env, jclass cls, jint filter)
{
	return (jint)gtk_file_filter_get_needed((GtkFileFilter*)filter);
}

/*
 * Class:     org_gnu_gtk_FileFilter
 * Method:    gtk_file_filter_filter
 * Signature: (II)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_FileFilter_gtk_1file_1filter_1filter
  (JNIEnv *env, jclass cls, jint filter, jint info)
{
	return (jboolean)gtk_file_filter_filter((GtkFileFilter*)filter, (GtkFileFilterInfo*)info);
}

#ifdef __cplusplus
}
#endif
#endif
