/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;
import org.gnu.glib.Boxed;
/**
 * Read only text appearance properties, as returned by methods relating to the
 * text view widgets. 
 */
public class TextAppearance extends Boxed 
{

	protected TextAppearance(int handle){
		this.handle = handle;
	}

	/**
	 */
	public org.gnu.gdk.Color getBgColor(){
		return new org.gnu.gdk.Color( getBgColor(handle) );
	}

	/**
	 */
	public org.gnu.gdk.Color getFgColor(){
		return new org.gnu.gdk.Color( getFgColor(handle) );
	}

	/**
	 */
	public org.gnu.gdk.Bitmap getBgStipple(){
		return new org.gnu.gdk.Bitmap( getBgStipple(handle) );
	}

	/**
	 */
	public org.gnu.gdk.Bitmap getFgStipple(){
		return new org.gnu.gdk.Bitmap( getFgStipple(handle) );
	}

	/**
	 * returns super/subscript rise, can be negative
	 */
	public int getRise(){
		return getRise(handle);
	}

	/**
	 */
	public org.gnu.pango.Underline getUnderline(){
		return org.gnu.pango.Underline.intern( getUnderline(handle) );
	}

	/**
	 * 
	 */
	public boolean getStrikethrough(){
		return getStrikethrough(handle);
	}

	/**
	 */
	public boolean getDrawBg(){
		return getDrawBg(handle);
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getBgColor (int cptr);
    native static final protected int getFgColor (int cptr);
    native static final protected int getBgStipple (int cptr);
    native static final protected int getFgStipple (int cptr);
    native static final protected int getRise (int cptr);
    native static final protected int getUnderline (int cptr);
    native static final protected boolean getStrikethrough (int cptr);
    native static final protected boolean getDrawBg (int cptr);
    native static final protected boolean getInsideSelection (int cptr);
    native static final protected boolean getIsText (int cptr);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

