#include <glib/gi18n-lib.h>
#include <libgnomedb/libgnomedb.h>
#include <gtk/gtk.h>

static gboolean delete_event( GtkWidget *widget,
                              GdkEvent  *event,
                              gpointer   data )
{
    g_print ("Leaving test...\n");

    return FALSE;
}

static void destroy( GtkWidget *widget,
                     gpointer   data )
{
    gtk_main_quit ();
}

GtkWidget *build_menu (GtkWidget *mainwin, GtkWidget *top_nb);
GtkWidget *build_main (GdaDict *dict, GdaDataHandler *dh, GType type);

static guint
gtype_hash (gconstpointer key)
{
	return (guint) key;
}

static gboolean 
gtype_equal (gconstpointer a, gconstpointer b)
{
	return (GType) a == (GType) b ? TRUE : FALSE;
}

GdaDataHandler* 
get_handler (GType for_type)
{
	static GHashTable *hash = NULL;
	if (!hash) {
		hash = g_hash_table_new_full (gtype_hash, gtype_equal, 
					      NULL, (GDestroyNotify) g_object_unref);

		g_hash_table_insert (hash, (gpointer) G_TYPE_INT64, gda_handler_numerical_new ());
		g_hash_table_insert (hash, (gpointer) G_TYPE_UINT64, gda_handler_numerical_new ());
		g_hash_table_insert (hash, (gpointer) GDA_TYPE_BINARY, gda_handler_bin_new ());
		g_hash_table_insert (hash, (gpointer) GDA_TYPE_BLOB, gda_handler_bin_new ());
		g_hash_table_insert (hash, (gpointer) G_TYPE_BOOLEAN, gda_handler_boolean_new ());
		g_hash_table_insert (hash, (gpointer) G_TYPE_DATE, gda_handler_time_new ());
		g_hash_table_insert (hash, (gpointer) G_TYPE_DOUBLE, gda_handler_numerical_new ());
		g_hash_table_insert (hash, (gpointer) G_TYPE_INT, gda_handler_numerical_new ());
		g_hash_table_insert (hash, (gpointer) GDA_TYPE_NUMERIC, gda_handler_numerical_new ());
		g_hash_table_insert (hash, (gpointer) G_TYPE_FLOAT, gda_handler_numerical_new ());
		g_hash_table_insert (hash, (gpointer) GDA_TYPE_SHORT, gda_handler_numerical_new ());
		g_hash_table_insert (hash, (gpointer) GDA_TYPE_USHORT, gda_handler_numerical_new ());
		g_hash_table_insert (hash, (gpointer) G_TYPE_STRING, gda_handler_string_new ());
		g_hash_table_insert (hash, (gpointer) GDA_TYPE_TIME, gda_handler_time_new ());
		g_hash_table_insert (hash, (gpointer) GDA_TYPE_TIMESTAMP, gda_handler_time_new ());
		g_hash_table_insert (hash, (gpointer) G_TYPE_CHAR, gda_handler_numerical_new ());
		g_hash_table_insert (hash, (gpointer) G_TYPE_UCHAR, gda_handler_numerical_new ());
		g_hash_table_insert (hash, (gpointer) G_TYPE_ULONG, gda_handler_type_new ());
		g_hash_table_insert (hash, (gpointer) G_TYPE_UINT, gda_handler_numerical_new ());		
	}

	return g_hash_table_lookup (hash, (gpointer) for_type);
}

int 
main (int argc, char **argv)
{
	GtkWidget *mainwin, *vbox, *wid, *nb, *label, *menu, *top_nb;
	GdaDict *dict;
	GSList *plugins, *list;
	GType type;
	GdaDataHandler *dh;
	gint i;

	/* Initialize i18n support */
	gtk_set_locale ();
	
	/* Initialize the widget set */
	gnome_db_init ("test-handlers", "", argc, argv);

	/* tested objects */
	dict = GDA_DICT (gda_dict_new ());

	/* Create the main window */
	mainwin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width (GTK_CONTAINER (mainwin), 0);
	g_signal_connect (G_OBJECT (mainwin), "delete_event",
			  G_CALLBACK (delete_event), NULL);
	g_signal_connect (G_OBJECT (mainwin), "destroy",
			  G_CALLBACK (destroy), NULL);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (mainwin), vbox);
	gtk_widget_show (vbox);

	/* top notebook */
	top_nb = gtk_notebook_new ();
	gtk_notebook_set_show_tabs (GTK_NOTEBOOK (top_nb), FALSE);
	gtk_widget_show (top_nb);
	menu = build_menu (mainwin, top_nb);
	gtk_widget_show (menu);
	gtk_box_pack_start (GTK_BOX (vbox), menu, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), top_nb, TRUE, TRUE, 0);

	/*
	 * Default handlers
	 */
	vbox = gtk_vbox_new (FALSE, 10);
	gtk_notebook_append_page (GTK_NOTEBOOK (top_nb), vbox, NULL);
	gtk_widget_show (vbox);

	label = gtk_label_new("");
	gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
	gtk_label_set_markup (GTK_LABEL (label), "<b>Default data entries:</b>\n"
			      "This test displays GnomeDbDataEntry widgets and helpers to test "
			      "them in pages of a notebook. Each page presents the default "
			      "data entry for the corresponding data type.");
	gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, TRUE, 5);
	gtk_widget_show (label);

	nb = gtk_notebook_new ();
	gtk_notebook_set_tab_pos (GTK_NOTEBOOK (nb), GTK_POS_LEFT);
	gtk_box_pack_start (GTK_BOX (vbox), nb, TRUE, TRUE, 0);
	gtk_widget_show (nb);

	/* populating the notebook */
	GType tested_gtypes [] = {G_TYPE_INT64, G_TYPE_UINT64, GDA_TYPE_BINARY, G_TYPE_BOOLEAN, GDA_TYPE_BLOB, G_TYPE_DATE, G_TYPE_DOUBLE,
				  GDA_TYPE_GEOMETRIC_POINT, G_TYPE_OBJECT, G_TYPE_INT, GDA_TYPE_LIST, 
				  GDA_TYPE_NUMERIC, G_TYPE_FLOAT, GDA_TYPE_SHORT, GDA_TYPE_USHORT, G_TYPE_STRING, 
				  GDA_TYPE_TIME, GDA_TYPE_TIMESTAMP, G_TYPE_CHAR, G_TYPE_UCHAR, G_TYPE_UINT};

	for (i = 0; i < sizeof (tested_gtypes) / sizeof (GType); i++) {
		type = tested_gtypes [i];
		dh = get_handler (type);
		wid = build_main (dict, dh, type);
		gtk_widget_show (wid);
		label = gtk_label_new (gda_type_to_string (type));
		gtk_notebook_append_page (GTK_NOTEBOOK (nb), wid, label);
	}

	/*
	 * Plugins page 
	 */
	vbox = gtk_vbox_new (FALSE, 10);
	gtk_notebook_append_page (GTK_NOTEBOOK (top_nb), vbox, NULL);
	gtk_widget_show (vbox);

	label = gtk_label_new("");
	gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
	gtk_label_set_markup (GTK_LABEL (label), "<b>Plugin data entries:</b>\n"
			      "This test displays GnomeDbDataEntry widgets and helpers to test "
			      "them in pages of a notebook. Each page tests a plugin for a given "
			      "data type");
	gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, TRUE, 5);
	gtk_widget_show (label);

	nb = gtk_notebook_new ();
	gtk_notebook_set_tab_pos (GTK_NOTEBOOK (nb), GTK_POS_LEFT);
	gtk_box_pack_start (GTK_BOX (vbox), nb, TRUE, TRUE, 0);
	gtk_widget_show (nb);

	/* populating the notebook */
	/* plugins = gda_connection_MIG_get_plugin_handlers (srv); */
/* 	list = plugins; */
/* 	while (list) { */
/* 		gint i, nbt; */
/* 		gchar *str; */

/* 		dh = GDA_DATA_HANDLER (list->data); */
/* 		nbt = gda_data_handler_get_nb_gda_types (dh); */
/* 		for (i=0; i<nbt; i++) { */
/* 			type = gda_data_handler_get_gda_type_index (dh, i); */
/* 			wid = build_main (dict, dh, type); */
/* 			gtk_widget_show (wid); */
/* 			str = g_strdup_printf ("%s\n(%s)", gda_data_handler_get_plugin_name (dh), */
/* 					       gda_type_to_string (type)); */
/* 			label = gtk_label_new (str); */
/* 			gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5); */
/* 			g_free (str); */
/* 			gtk_notebook_append_page (GTK_NOTEBOOK (nb), wid, label); */
/* 		} */
/* 		list = g_slist_next (list); */
/* 	} */
/* 	g_slist_free (plugins); */
		




	/* Show the application window */
	gtk_widget_show (mainwin);
	
	gtk_main ();
	g_object_unref (G_OBJECT (dict));

	return 0;
}

void entry_contents_modified (GtkWidget *entry, gpointer data);
void null_toggled_cb (GtkToggleButton *button, GtkWidget *entry);
void default_toggled_cb (GtkToggleButton *button, GtkWidget *entry);
void actions_toggled_cb (GtkToggleButton *button, GtkWidget *entry);
void orig_clicked_cb (GtkButton *button, GtkWidget *entry);
void default_clicked_cb (GtkButton *button, GtkWidget *entry);
GtkWidget *
build_main (GdaDict *dict, GdaDataHandler *dh, GType type)
{
	GtkWidget *wid, *label, *table, *button, *bbox, *entry, *vbox;
	GString *string;
	
	vbox = gtk_vbox_new (FALSE, 0);

	table = gtk_table_new (7, 2, FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table), 5);
	gtk_table_set_row_spacings (GTK_TABLE (table), 5);
	gtk_box_pack_start (GTK_BOX (vbox), table, FALSE, FALSE, 0);

	/* explain top label */
	string = g_string_new ("");
	if (dh)
		g_string_append_printf (string, "<b>Description:</b> %s\n",
					gda_data_handler_get_descr (dh));
	else
		g_string_append_printf (string, "<b>Description:</b> %s\n",
					_("No GdaDataHandler available for this type"));
	label = gtk_label_new ("");
	gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
	gtk_label_set_markup (GTK_LABEL (label), string->str);
	g_string_free (string, TRUE);
	gtk_table_attach (GTK_TABLE (table), label, 0, 2, 0, 1, GTK_FILL | GTK_EXPAND, 0, 0, 0);
	gtk_widget_show (label);

	/* widget being tested */
	wid = GTK_WIDGET (gnome_db_util_new_data_entry (NULL, type, NULL));
	if (gnome_db_data_entry_expand_in_layout (GNOME_DB_DATA_ENTRY (wid)))
		gtk_table_attach_defaults (GTK_TABLE (table), wid, 0, 2, 1, 2);
	else
		gtk_table_attach (GTK_TABLE (table), wid, 0, 2, 1, 2, GTK_FILL | GTK_EXPAND, 0, 0, 0);
	gtk_widget_show (wid);

	/* Other widgets */
	label = gtk_label_new (_("Current flags: "));
	gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3, GTK_FILL, 0, 0, 0);
	gtk_widget_show (label);	

	label = gtk_label_new (_("--"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 2, 3);
	g_object_set_data (G_OBJECT (wid), "flags", label);
	gtk_widget_show (label);

	label = gtk_label_new (_("Current value: "));
	gtk_misc_set_alignment (GTK_MISC (label), 0, 0);
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 3, 4, GTK_FILL, GTK_FILL, 0, 0);
	gtk_widget_show (label);
	
	label = gtk_label_new ("");
	gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 3, 4);
	g_object_set_data (G_OBJECT (wid), "value", label);
	g_signal_connect (G_OBJECT (wid), "contents_modified",
			  G_CALLBACK (entry_contents_modified), NULL);
	gtk_widget_show (label);

	entry_contents_modified (wid, GTK_LABEL (label));

	bbox = gtk_hbutton_box_new ();
	gtk_table_attach (GTK_TABLE (table), bbox, 0, 2, 4, 5, 0, 0, 0, 0);
		
	button = gtk_toggle_button_new_with_label (_("NULL ok"));
	g_signal_connect (G_OBJECT (button), "toggled",
			  G_CALLBACK (null_toggled_cb), wid);
	gtk_container_add (GTK_CONTAINER (bbox), button);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button),
				      gnome_db_data_entry_get_attributes (GNOME_DB_DATA_ENTRY (wid)) & 
				      GDA_VALUE_ATTR_CAN_BE_NULL);

	button = gtk_toggle_button_new_with_label (_("DEFAULT ok"));
	g_signal_connect (G_OBJECT (button), "toggled",
			  G_CALLBACK (default_toggled_cb), wid);
	gtk_container_add (GTK_CONTAINER (bbox), button);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button),
				      gnome_db_data_entry_get_attributes (GNOME_DB_DATA_ENTRY (wid)) & 
				      GDA_VALUE_ATTR_CAN_BE_DEFAULT);

	button = gtk_toggle_button_new_with_label (_("Actions?"));
	g_signal_connect (G_OBJECT (button), "toggled",
			  G_CALLBACK (actions_toggled_cb), wid);
	gtk_container_add (GTK_CONTAINER (bbox), button);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button),
				      gnome_db_data_entry_get_attributes (GNOME_DB_DATA_ENTRY (wid)) & 
				      GDA_VALUE_ATTR_ACTIONS_SHOWN);
	gtk_widget_show_all (bbox);

	/* to set the original value */
	entry = GTK_WIDGET (gnome_db_util_new_data_entry (NULL, type, NULL));
	gtk_table_attach (GTK_TABLE (table), entry, 0, 1, 5, 6, GTK_FILL | GTK_EXPAND, 0, 0, 0);
	gtk_widget_show (entry);
	button = gtk_button_new_with_label (_("Set as original"));
	g_object_set_data (G_OBJECT (button), "entry", entry);
	gtk_table_attach (GTK_TABLE (table), button, 1, 2, 5, 6, 0, 0, 0, 0);
	gtk_widget_show (button);
	g_signal_connect (G_OBJECT (button), "clicked",
			  G_CALLBACK (orig_clicked_cb), wid);

	/* to set the default value */
	entry = GTK_WIDGET (gnome_db_util_new_data_entry (NULL, type, NULL));
	gtk_table_attach (GTK_TABLE (table), entry, 0, 1, 6, 7, GTK_FILL | GTK_EXPAND, 0, 0, 0);
	gtk_widget_show (entry);
	button = gtk_button_new_with_label (_("Set as default"));
	g_object_set_data (G_OBJECT (button), "entry", entry);
	gtk_table_attach (GTK_TABLE (table), button, 1, 2, 6, 7, 0, 0, 0, 0);
	gtk_widget_show (button);
	g_signal_connect (G_OBJECT (button), "clicked",
			  G_CALLBACK (default_clicked_cb), wid);

	gtk_widget_show (table);

	label = gtk_label_new("");
	gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
	gtk_widget_show (label);

	gtk_widget_show (vbox);

	return vbox;
}

void 
null_toggled_cb (GtkToggleButton *button, GtkWidget *entry)
{
	guint action = 0;
	if (gtk_toggle_button_get_active (button))
		action = GDA_VALUE_ATTR_CAN_BE_NULL;

	gnome_db_data_entry_set_attributes (GNOME_DB_DATA_ENTRY (entry),
				      action, GDA_VALUE_ATTR_CAN_BE_NULL);
	gtk_toggle_button_set_active (button,
				      gnome_db_data_entry_get_attributes (GNOME_DB_DATA_ENTRY (entry)) & 
				      GDA_VALUE_ATTR_CAN_BE_NULL);
}

void
default_toggled_cb (GtkToggleButton *button, GtkWidget *entry)
{
	guint action = 0;
	if (gtk_toggle_button_get_active (button))
		action = GDA_VALUE_ATTR_CAN_BE_DEFAULT;

	gnome_db_data_entry_set_attributes (GNOME_DB_DATA_ENTRY (entry),
				      action, GDA_VALUE_ATTR_CAN_BE_DEFAULT);
	gtk_toggle_button_set_active (button,
				      gnome_db_data_entry_get_attributes (GNOME_DB_DATA_ENTRY (entry)) & 
				      GDA_VALUE_ATTR_CAN_BE_DEFAULT);
}

void
actions_toggled_cb (GtkToggleButton *button, GtkWidget *entry)
{
	guint action = 0;
	if (gtk_toggle_button_get_active (button))
		action = GDA_VALUE_ATTR_ACTIONS_SHOWN;

	gnome_db_data_entry_set_attributes (GNOME_DB_DATA_ENTRY (entry),
				      action, GDA_VALUE_ATTR_ACTIONS_SHOWN);
	gtk_toggle_button_set_active (button,
				      gnome_db_data_entry_get_attributes (GNOME_DB_DATA_ENTRY (entry)) & 
				      GDA_VALUE_ATTR_ACTIONS_SHOWN);
}

void 
entry_contents_modified (GtkWidget *entry, gpointer data)
{
	guint attrs;
	GtkLabel *label;
	GString *str = g_string_new ("");
	GValue *value;
	GdaDataHandler *dh;

	/* flags */
	label = g_object_get_data (G_OBJECT (entry), "flags");
	attrs = gnome_db_data_entry_get_attributes (GNOME_DB_DATA_ENTRY (entry));
	if (attrs & GDA_VALUE_ATTR_IS_NULL)
		g_string_append (str, "N ");
	if (attrs & GDA_VALUE_ATTR_IS_DEFAULT)
		g_string_append (str, "D ");
	if (!(attrs & GDA_VALUE_ATTR_IS_UNCHANGED))
		g_string_append (str, "M ");
	if (attrs & GDA_VALUE_ATTR_DATA_NON_VALID)
		g_string_append (str, "U ");

	gtk_label_set_text (label, str->str);
	g_string_free (str, TRUE);

	/* value */
	label = g_object_get_data (G_OBJECT (entry), "value");
	value = gnome_db_data_entry_get_value (GNOME_DB_DATA_ENTRY (entry));
	dh = gnome_db_data_entry_get_handler (GNOME_DB_DATA_ENTRY (entry));
	if (dh) {
		gchar *strval;
		strval = gda_data_handler_get_sql_from_value (dh, value);
		gda_value_free (value);
		gtk_label_set_text (label, strval);
		g_free (strval);
	}
}

void
orig_clicked_cb (GtkButton *button, GtkWidget *entry)
{
	GtkWidget *wid;
	GValue *value;

	wid = g_object_get_data (G_OBJECT (button), "entry");
	value = gnome_db_data_entry_get_value (GNOME_DB_DATA_ENTRY (wid));
	g_print ("Setting to original Value %p ", value);
	if (value) {
		if (G_VALUE_TYPE (value) == GDA_TYPE_NULL)
			g_print ("GDA_TYPE_NULL\n");
		else
			g_print ("type = %d\n", G_VALUE_TYPE (value));
	}
	
	gnome_db_data_entry_set_value_orig (GNOME_DB_DATA_ENTRY (entry), value);
	gda_value_free (value);
}

void
default_clicked_cb (GtkButton *button, GtkWidget *entry)
{
	GtkWidget *wid;
	GValue *value;

	wid = g_object_get_data (G_OBJECT (button), "entry");
	value = gnome_db_data_entry_get_value (GNOME_DB_DATA_ENTRY (wid));
	gnome_db_data_entry_set_value_default (GNOME_DB_DATA_ENTRY (entry), value);
	gda_value_free (value);
}



/*
 * Menu
 */
static void on_default_handlers1_activate (GtkMenuItem *item, GtkWidget *top_nb);
static void on_plugins1_activate (GtkMenuItem *item, GtkWidget *top_nb);
GtkWidget *
build_menu (GtkWidget *mainwin, GtkWidget *top_nb)
{
	GtkWidget *menubar1, *menuitem1, *menuitem1_menu, *quit1, *menuitem2, *menuitem2_menu;
	GtkWidget *default_handlers1, *plugins1;
	GtkAccelGroup *accel_group;

	accel_group = gtk_accel_group_new ();

	menubar1 = gtk_menu_bar_new ();
	gtk_widget_show (menubar1);

	menuitem1 = gtk_menu_item_new_with_mnemonic (_("_File"));
	gtk_widget_show (menuitem1);
	gtk_container_add (GTK_CONTAINER (menubar1), menuitem1);
	
	menuitem1_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem1), menuitem1_menu);
	
	quit1 = gtk_image_menu_item_new_from_stock ("gtk-quit", accel_group);
	gtk_widget_show (quit1);
	gtk_container_add (GTK_CONTAINER (menuitem1_menu), quit1);

	menuitem2 = gtk_menu_item_new_with_mnemonic (_("_Page"));
	gtk_widget_show (menuitem2);
	gtk_container_add (GTK_CONTAINER (menubar1), menuitem2);
	
	menuitem2_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem2), menuitem2_menu);
	
	default_handlers1 = gtk_menu_item_new_with_mnemonic (_("Default handlers"));
	gtk_widget_show (default_handlers1);
	gtk_container_add (GTK_CONTAINER (menuitem2_menu), default_handlers1);
	
	plugins1 = gtk_menu_item_new_with_mnemonic (_("Plugins"));
	gtk_widget_show (plugins1);
	gtk_container_add (GTK_CONTAINER (menuitem2_menu), plugins1);
	
	g_signal_connect ((gpointer) quit1, "activate",
			  G_CALLBACK (destroy), NULL);
	g_signal_connect ((gpointer) default_handlers1, "activate",
			  G_CALLBACK (on_default_handlers1_activate), top_nb);
	g_signal_connect ((gpointer) plugins1, "activate",
			  G_CALLBACK (on_plugins1_activate), top_nb);

	gtk_window_add_accel_group (GTK_WINDOW (mainwin), accel_group);

	return menubar1;
}

static void
on_default_handlers1_activate (GtkMenuItem *item, GtkWidget *top_nb)
{
	gtk_notebook_set_current_page (GTK_NOTEBOOK (top_nb), 0);
}

static void
on_plugins1_activate (GtkMenuItem *item, GtkWidget *top_nb)
{
	gtk_notebook_set_current_page (GTK_NOTEBOOK (top_nb), 1);
}
