/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gnome;
import org.gnu.glib.Type;
/**
 *
 */
public class CanvasRichText extends CanvasItem {
	/**
	 * Constructs an instance of CanvasRichText from a native widget resource.
	 * @param handle The handle to the native widget.
	 */
	CanvasRichText(int handle) {
		super(handle);
	}

	protected void noopInit() {
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gnome_canvas_rich_text_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gnome_canvas_rich_text_get_type();
	native static final protected void gnome_canvas_rich_text_cut_clipboard(int text);
	native static final protected void gnome_canvas_rich_text_copy_clipboard(int text);
	native static final protected void gnome_canvas_rich_text_paste_clipboard(int text);
	native static final protected void gnome_canvas_rich_text_set_buffer(int text, int buffer);
	native static final protected int gnome_canvas_rich_text_get_buffer(int text);
	native static final protected void gnome_canvas_rich_text_get_iter_location(int text, int iter, int location);
	native static final protected void gnome_canvas_rich_text_get_iter_at_location(int text, int iter, int x, int y);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
