/*
  gyrus-common.c - Common modules.

  GYRUS -- GNOME Cyrus Administrator.

  Copyright (C) 2003-2004 Claudio Saavedra V.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  
*/

#include <gtk/gtk.h>
#include <string.h>
#include <glade/glade.h>
#include "gyrus-i18n.h"
#include "gyrus-common.h"

void
gyrus_common_show_message (GtkWindow *parent,
			   GtkMessageType type,
			   const gchar* message)
{
	GtkWidget *dialog;

	dialog = gtk_message_dialog_new (parent, GTK_DIALOG_MODAL,
				 type, GTK_BUTTONS_OK, message);
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
}

gboolean
gtk_entry_has_text (GtkEntry *entry)
{
	gboolean has_text;
	g_return_val_if_fail (entry != NULL, FALSE);
	g_return_val_if_fail (GTK_IS_ENTRY (entry), FALSE);

	gchar *text = g_strdup (gtk_entry_get_text (entry));
	has_text = strlen (g_strstrip (text)) > 0;
	g_free (text);
	return (has_text);
}

gchar *
gyrus_dialog_password_new (void)
{
	GladeXML *xml;
	gchar *file_glade;
	GtkWidget *dialog;
	GtkWidget *entry_password;
	gchar *password = NULL;
	
	file_glade = g_strdup_printf ("%s%c%s", GYRUS_GLADE_DIR,
				      G_DIR_SEPARATOR, "page.glade");
	xml = glade_xml_new (file_glade, "dialog_password", "gyrus");
	g_free (file_glade);
	
	dialog         = glade_xml_get_widget (xml, "dialog_password");
	entry_password = glade_xml_get_widget (xml, "entry_password");
	
	gint result = gtk_dialog_run (GTK_DIALOG (dialog));

	switch (result) {
	case GTK_RESPONSE_OK:
		password = g_strdup (gtk_entry_get_text
				     (GTK_ENTRY (entry_password)));
		break;
	case GTK_RESPONSE_CANCEL:
		password = NULL;
	}
	gtk_widget_destroy (dialog);

	return password;
}

gboolean
gyrus_common_str_is_ascii (const gchar *str)
{
	while (*str) {
		if ((guchar)*str >= 128)
			return FALSE;
		str++;
	}
	return TRUE;
}
