"""
Stores the Preferences per-applet or shared across applets
"""
import gconf
import colorblind

class ColorblindAppletPreferences:
	def __init__(self, applet):
		# Default values
		self.GCONF_APPLET_DIR = colorblind.GCONF_DIR
		
		# These preferences are shared across all applet instances
		# unlike width, which is per-instance.
		self.GCONF_KEYBINDING_ONOFF = colorblind.GCONF_KEYBINDING_ONOFF
		self.GCONF_KEYBINDING_SWITCH = colorblind.GCONF_KEYBINDING_SWITCH
		
		# Retreive this applet's pref folder
		path = applet.get_preferences_key()
		if path != None:
			self.GCONF_APPLET_DIR = path
			
			applet.add_preferences("/schemas" + colorblind.GCONF_DIR)
			colorblind.GCONF_CLIENT.add_dir(self.GCONF_APPLET_DIR, gconf.CLIENT_PRELOAD_RECURSIVE)
			
			print 'Using per-applet gconf key:', self.GCONF_APPLET_DIR
		
