/***************************************************************************
 *  TrackStruct.cs
 *
 *  Copyright (C) 2006-2007 Alan McGovern
 *  Authors:
 *  Alan McGovern (alan.mcgovern@gmail.com)
 ****************************************************************************/

/*  THIS FILE IS LICENSED UNDER THE MIT LICENSE AS OUTLINED IMMEDIATELY BELOW: 
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),  
 *  to deal in the Software without restriction, including without limitation  
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,  
 *  and/or sell copies of the Software, and to permit persons to whom the  
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

using System;
using System.Runtime.InteropServices;

namespace libmtpsharp
{
	[StructLayout(LayoutKind.Sequential)]
	internal struct TrackStruct
	{
		public uint item_id;
		public uint parent_id;
		
		[MarshalAs(UnmanagedType.LPStr)] public string title;
		[MarshalAs(UnmanagedType.LPStr)] public string artist;
		[MarshalAs(UnmanagedType.LPStr)] public string genre;
		[MarshalAs(UnmanagedType.LPStr)] public string album;
		[MarshalAs(UnmanagedType.LPStr)] public string date;
		[MarshalAs(UnmanagedType.LPStr)] public string filename;

		public ushort tracknumber;
		public uint duration;
		public uint samplerate;
		public ushort nochannels;
		public uint wavecodec;
		public uint bitrate;
		public ushort bitratetype;
		public ushort rating;    // 0 -> 100
		public uint usecount;
		public ulong filesize;
		public FileType filetype;
		public IntPtr next; // Track Null if last
		/*
		public Track? Next
		{
			get
			{
				if (next == IntPtr.Zero)
					return null;
				return (Track)Marshal.PtrToStructure(next, typeof(Track));
			}
		}*/
	}
}
