/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-terminal.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-terminal
 * @title: IAnjutaTerminal
 * @short_description: Interface for command line terminals
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-terminal.h
 * 
 */

#include "ianjuta-terminal.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_terminal_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-terminal-quark");
	}
	
	return quark;
}

/**
* ianjuta_terminal_execute_command:
* @obj: Self
* @directory: fixme
* @command: fixme
* @err: Error propagation and reporting.
*
* fixme
* 
* Returns: fixme
*/
pid_t
ianjuta_terminal_execute_command (IAnjutaTerminal *obj, const gchar* directory,   const gchar *command, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_TERMINAL(obj), 0);
	return IANJUTA_TERMINAL_GET_IFACE (obj)->execute_command (obj, directory, command, err);
}

/* Default implementation */
static pid_t
ianjuta_terminal_execute_command_default (IAnjutaTerminal *obj, const gchar* directory,   const gchar *command, GError **err)
{
	g_return_val_if_reached (0);
}

static void
ianjuta_terminal_base_init (IAnjutaTerminalIface* klass)
{
	static gboolean initialized = FALSE;

	klass->execute_command = ianjuta_terminal_execute_command_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_terminal_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaTerminalIface),
			(GBaseInitFunc) ianjuta_terminal_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaTerminal", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
