(development_docker)=

# Building Docker Containers for PDAL

PDAL's {ref}`repository <source>` is linked to [DockerHub] for automatic
building of [Docker] containers. PDAL keeps three Docker containers current.

- `pdal/ubuntu-dependencies:latest` -- PDAL's dependencies
- `pdal/pdal:latest` -- PDAL master
- `pdal/pdal:1.5` -- PDAL maintenance branch

```{note}
Containers are built upon the [Dependencies] container, but the
[Dependencies] container is not pinned to specific Bionic or PDAL release
times. It corresponds to where ever the `dependencies` tag of the PDAL
source tree at <https://github.com/PDAL/PDAL> resides
```

## Dependencies

The PDAL dependencies Docker container is used by both the latest and release
branch Docker containers. The dependencies container is also used during
{ref}`integration` testing by Travis. It is built using the Dockerfile at
<https://github.com/PDAL/PDAL/blob/master/scripts/docker/ubuntu/Dockerfile>

The `pdal/dependencies:latest` image is regenerated by force-pushing a tag of
the SHA you wish to use to have [DockerHub] build.

```
git tag -f dependencies
git push origin refs/tags/dependencies -f
```

```{note}
The dependencies container is currently built upon [Ubuntu Bionic]. When
the next Ubuntu LTS is released, the PDAL project will likely move to it.
```

## Maintenance

A PDAL container corresponding to the last major release is automatically
created and maintained with every commit to the active release branch. For
example, the `1.4-maintenance` branch will have a corresponding
`pdal/pdal:1.4` container made with every commit on [DockerHub]. Users are
encouraged to use these containers for testing, bug confirmation, and deployment

```{figure} ../images/docker-maintenance-branch.png
Docker containers on maintenance branch correspond to major PDAL releases.
```

## Latest (or master)

A PDAL container corresponding to a developer-selected release point is made
available at `pdal/pdal:latest` and corresponds to the manual push of a
`docker-master` tag by PDAL developers. This container is typically used for
testing and verification of fixes, and it is recommended that users looking to
depend on PDAL's Docker containers always use known release versions off of the
last stable release branch.

```{warning}
You should be using the [Maintenance] Docker container for any
production-oriented operations. Only use the latest one to test or prototype
a latest, unreleased feature.
```

```{figure} ../images/docker-master-branch.png
The `pdal/pdal:latest` branch is current relative to the `docker-master`
branch in GitHub.
```

```
$ git tag -f docker-master
$ git push origin refs/tags/docker-master -f
```

[docker]: https://www.docker.com/
[dockerhub]: https://hub.docker.com/r/pdal/pdal/
[ubuntu bionic]: http://releases.ubuntu.com/18.04/
