/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.vfs.impl;

import java.util.concurrent.atomic.AtomicReference;
import org.gradle.internal.file.FileHierarchySet;
import org.gradle.internal.vfs.FileSystemAccess;

public class FileWatchingFilter
implements FileSystemAccess.WriteListener {
    private final FileHierarchySet immutableLocations;
    private final AtomicReference<FileHierarchySet> locationsWrittenByCurrentBuild = new AtomicReference<FileHierarchySet>(FileHierarchySet.empty());
    private volatile boolean buildRunning;

    public FileWatchingFilter(FileHierarchySet immutableLocations) {
        this.immutableLocations = immutableLocations;
    }

    public void locationsWritten(Iterable<String> locations) {
        if (this.buildRunning) {
            this.locationsWrittenByCurrentBuild.updateAndGet(currentValue -> {
                FileHierarchySet newValue = currentValue;
                for (String location : locations) {
                    newValue = newValue.plus(location);
                }
                return newValue;
            });
        }
    }

    public boolean shouldWatchLocation(String location) {
        return !this.locationsWrittenByCurrentBuild.get().contains(location);
    }

    public FileHierarchySet getImmutableLocations() {
        return this.immutableLocations;
    }

    public void buildStarted() {
        this.resetLocationsWritten();
        this.buildRunning = true;
    }

    public void buildFinished() {
        this.resetLocationsWritten();
        this.buildRunning = false;
    }

    private void resetLocationsWritten() {
        this.locationsWrittenByCurrentBuild.set(this.immutableLocations);
    }
}

