/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.validation;

import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.problems.internal.InternalProblemBuilder;
import org.gradle.internal.reflect.validation.DelegatingProblemBuilder;
import org.gradle.internal.reflect.validation.TypeAwareProblemBuilder;

@NonNullApi
public class DefaultTypeAwareProblemBuilder
extends DelegatingProblemBuilder
implements TypeAwareProblemBuilder {
    public static final String TYPE_NAME = "typeName";
    public static final String PLUGIN_ID = "pluginId";
    public static final String PARENT_PROPERTY_NAME = "parentPropertyName";
    public static final String PROPERTY_NAME = "propertyName";
    public static final String TYPE_IS_IRRELEVANT_IN_ERROR_MESSAGE = "typeIsIrrelevantInErrorMessage";
    private String parentPropertyAdditionalData = null;

    public DefaultTypeAwareProblemBuilder(InternalProblemBuilder problemBuilder) {
        super(problemBuilder);
    }

    @Override
    public TypeAwareProblemBuilder withAnnotationType(@Nullable Class<?> classWithAnnotationAttached) {
        if (classWithAnnotationAttached != null) {
            this.additionalData(TYPE_NAME, classWithAnnotationAttached.getName().replaceAll("\\$", "."));
        }
        return this;
    }

    @Override
    public TypeAwareProblemBuilder typeIsIrrelevantInErrorMessage() {
        this.additionalData(TYPE_IS_IRRELEVANT_IN_ERROR_MESSAGE, Boolean.TRUE.toString());
        return this;
    }

    @Override
    public TypeAwareProblemBuilder forProperty(String propertyName) {
        this.additionalData(PROPERTY_NAME, propertyName);
        return this;
    }

    @Override
    public TypeAwareProblemBuilder parentProperty(@Nullable String parentProperty) {
        if (parentProperty == null) {
            return this;
        }
        String pp = this.getParentProperty(parentProperty);
        this.additionalData(PARENT_PROPERTY_NAME, pp);
        this.parentPropertyAdditionalData = pp;
        return this;
    }

    private String getParentProperty(String parentProperty) {
        String existingParentProperty = this.parentPropertyAdditionalData;
        if (existingParentProperty == null) {
            return parentProperty;
        }
        return existingParentProperty + "." + parentProperty;
    }
}

