/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.svgsupport;

import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;

public class FontResourceDescriptor
extends DeviceResourceDescriptor {
    private String fontFamily;
    private int fontSize = 0;
    private int style = 0;

    public FontResourceDescriptor(String fontFamily, int fontSize, int style) {
        this.fontFamily = fontFamily;
        this.fontSize = fontSize;
        this.style = style;
    }

    public Font createResource(Device device) {
        return new Font(device, this.fontFamily, this.fontSize, this.style);
    }

    public void destroyResource(Object obj) {
        Font font;
        if (obj instanceof Font && !(font = (Font)obj).isDisposed()) {
            font.dispose();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof FontResourceDescriptor) {
            FontResourceDescriptor desc = (FontResourceDescriptor)((Object)obj);
            if (this == desc) {
                return true;
            }
            if ((this.fontFamily == desc.fontFamily || this.fontFamily.equals(desc.fontFamily)) && this.fontSize == desc.fontSize && this.style == desc.style) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.fontSize;
        result = 31 * result + this.style;
        result = 31 * result + this.fontFamily.hashCode();
        return result;
    }

    public String toString() {
        String str = "Font( ";
        str = String.valueOf(str) + "font family:" + this.fontFamily;
        str = String.valueOf(str) + ", font size:" + this.fontSize + ")";
        return str;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public int getStyle() {
        return this.style;
    }
}

