/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.meggy;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.xmind.core.Core;
import org.xmind.core.IWorkbook;
import org.xmind.core.io.ByteArrayStorage;
import org.xmind.core.io.IStorage;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.CloneHandler;
import org.xmind.core.util.Property;
import org.xmind.ui.internal.meggy.StyleDescriptor;

public class ThemeDescriptor {
    private final Map<String, StyleDescriptor> defaultStyles = new HashMap<String, StyleDescriptor>();
    private final IWorkbook tempWorkbook = Core.getWorkbookBuilder().createWorkbook((IStorage)new ByteArrayStorage());

    public boolean isEmpty() {
        return this.defaultStyles.isEmpty();
    }

    public void add(IStyle sourceStyle, String family, String type, int weight) throws IOException {
        Assert.isLegal((sourceStyle != null ? 1 : 0) != 0);
        Assert.isLegal((family != null ? 1 : 0) != 0);
        Assert.isLegal((type != null ? 1 : 0) != 0);
        CloneHandler cloneHandler = new CloneHandler().withStyleSheets(sourceStyle.getOwnedStyleSheet(), this.tempWorkbook.getStyleSheet());
        IStyle tempStyle = (IStyle)cloneHandler.cloneObject((Object)sourceStyle);
        if (tempStyle == null) {
            return;
        }
        StyleDescriptor styleDescriptor = this.getStyleDescriptor(family, type);
        Iterator pIt = tempStyle.properties();
        while (pIt.hasNext()) {
            Property p = (Property)pIt.next();
            styleDescriptor.add(p.key, p.value, weight);
        }
    }

    private StyleDescriptor getStyleDescriptor(String family, String type) {
        StyleDescriptor descriptor = this.defaultStyles.get(family);
        if (descriptor == null) {
            descriptor = new StyleDescriptor(type);
            this.defaultStyles.put(family, descriptor);
        }
        return descriptor;
    }

    public IStyle createTheme(IStyleSheet targetStyleSheet) throws IOException {
        Assert.isLegal((targetStyleSheet != null ? 1 : 0) != 0);
        CloneHandler cloneHandler = new CloneHandler().withStyleSheets(this.tempWorkbook.getStyleSheet(), targetStyleSheet);
        IStyle theme = targetStyleSheet.createStyle("theme");
        for (Map.Entry<String, StyleDescriptor> en : this.defaultStyles.entrySet()) {
            String family = en.getKey();
            StyleDescriptor styleDescriptor = en.getValue();
            IStyle tempStyle = styleDescriptor.createStyle(this.tempWorkbook.getStyleSheet());
            IStyle targetStyle = (IStyle)cloneHandler.cloneObject((Object)tempStyle);
            if (targetStyle == null) continue;
            targetStyleSheet.addStyle(targetStyle, "automatic-styles");
            theme.setDefaultStyleId(family, targetStyle.getId());
        }
        targetStyleSheet.addStyle(theme, "master-styles");
        return theme;
    }
}

