/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.audionotes;

import java.util.List;
import org.xmind.core.IFileEntry;
import org.xmind.core.IResourceRef;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.ui.internal.audionotes.AudioNotesAgent;
import org.xmind.ui.internal.audionotes.AudioNotesPlugin;
import org.xmind.ui.internal.audionotes.Messages;
import org.xmind.ui.util.TextFormatter;

public class AudioNotesUtils {
    public static String getAudioEntryPath(ITopic topic) {
        List resourceRefs;
        ITopicExtension extension = topic.getExtension("org.xmind.ui.audionotes");
        if (extension != null && !(resourceRefs = extension.getResourceRefs()).isEmpty()) {
            for (IResourceRef ref : resourceRefs) {
                String entryPath;
                if (!"file-entry".equals(ref.getType()) || (entryPath = ref.getResourceId()) == null) continue;
                return entryPath;
            }
        }
        return null;
    }

    public static IFileEntry getAudioEntry(ITopic topic) {
        String entryPath = AudioNotesUtils.getAudioEntryPath(topic);
        if (entryPath != null) {
            return topic.getOwnedWorkbook().getManifest().getFileEntry(entryPath);
        }
        return null;
    }

    public static String getDuration(ITopic topic) {
        if (topic == null) {
            return null;
        }
        ITopicExtension ext = topic.getExtension("org.xmind.ui.audionotes");
        if (ext == null) {
            return null;
        }
        ITopicExtensionElement content = ext.getContent();
        List c = content.getChildren("duration");
        if (!c.isEmpty()) {
            return ((ITopicExtensionElement)c.get(0)).getTextContent();
        }
        return null;
    }

    public static String getRecordTime(ITopic topic) {
        ITopicExtension ext = topic.getExtension("org.xmind.ui.audionotes");
        if (ext == null) {
            return null;
        }
        ITopicExtensionElement content = ext.getContent();
        List c = content.getChildren("record-time");
        if (!c.isEmpty()) {
            return ((ITopicExtensionElement)c.get(0)).getTextContent();
        }
        return null;
    }

    public static String getFileSize(ITopic topic) {
        if (topic != null) {
            ITopicExtension ext = topic.getExtension("org.xmind.ui.audionotes");
            if (ext == null) {
                return null;
            }
            ITopicExtensionElement content = ext.getContent();
            List c = content.getChildren("file-size");
            if (!c.isEmpty()) {
                return ((ITopicExtensionElement)c.get(0)).getTextContent();
            }
        }
        return null;
    }

    public static String formatFileSize(String size) {
        try {
            long value = Long.parseLong(size);
            return TextFormatter.toFileSize((long)value);
        }
        catch (NumberFormatException numberFormatException) {
            return size;
        }
    }

    public static String formatTime(String time) {
        try {
            return AudioNotesUtils.formatTime(Long.parseLong(time));
        }
        catch (NumberFormatException numberFormatException) {
            return time;
        }
    }

    public static String formatTime(long time) {
        long s = (time /= 1000L) % 60L;
        long m = time / 60L % 60L;
        if (time > 3600L) {
            long h = time / 3600L;
            return String.format("%02d:%02d:%02d", h, m, s);
        }
        return String.format("%02d:%02d", m, s);
    }

    public static String formatTitle(ITopic topic, boolean hasAudioNotes) {
        boolean showParent;
        AudioNotesAgent agent = AudioNotesPlugin.getDefault().getAgent();
        if (agent.isRecording() || agent.isPlaying()) {
            showParent = true;
            ITopic t = agent.getCurrentTopic();
            if (t != null) {
                topic = t;
            }
        } else {
            showParent = hasAudioNotes;
        }
        if (topic != null) {
            ITopic parent;
            if (showParent && (parent = topic.getParent()) != null) {
                return String.format("%s - %s", TextFormatter.removeNewLineCharacter((String)parent.getTitleText()), TextFormatter.removeNewLineCharacter((String)topic.getTitleText()));
            }
            return TextFormatter.removeNewLineCharacter((String)topic.getTitleText());
        }
        return Messages.SelectTopic;
    }
}

