/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.jxp.config;

import org.onemind.commons.java.xml.digest.AbstractElementCreatorDigester;
import org.onemind.commons.java.xml.digest.ElementListener;
import org.onemind.commons.java.xml.digest.SaxDigesterHandler;
import org.onemind.jxp.JxpPageSource;
import org.onemind.jxp.JxpProcessor;
import org.onemind.jxp.config.FileSourceDigester;
import org.onemind.jxp.config.MultiSourceDigester;
import org.onemind.jxp.config.StreamSourceDigester;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class JxpConfigDigester
extends AbstractElementCreatorDigester
implements ElementListener {
    private JxpProcessor _processor;

    public JxpConfigDigester() {
        super("jxp");
    }

    public Object createElement(SaxDigesterHandler handler, Attributes attr) throws SAXException {
        this._processor = new JxpProcessor();
        String pageSourcePath = "pagesources";
        MultiSourceDigester dig = new MultiSourceDigester();
        dig.addListener(this);
        handler.addSubDigester(pageSourcePath, dig);
        FileSourceDigester fdig = new FileSourceDigester();
        fdig.addListener(this);
        handler.addSubDigester(pageSourcePath, fdig);
        StreamSourceDigester sdig = new StreamSourceDigester();
        sdig.addListener(this);
        handler.addSubDigester(pageSourcePath, sdig);
        return this._processor;
    }

    public void objectCreated(Object obj) {
        this._processor.setSource((JxpPageSource)obj);
    }

    public JxpProcessor getProcessor() {
        return this._processor;
    }

    public void endDigest(SaxDigesterHandler handler) throws SAXException {
        if (this._processor == null) {
            throw new SAXException("Jxp processor config is missing in the config");
        }
    }
}

