/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.boot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.java.plugin.util.ResourceManager;

public class ErrorDialog
extends JDialog {
    private static final long serialVersionUID = 7142861251076530780L;
    private JPanel jContentPane = null;
    private JPanel jPanel = null;
    private JLabel messageLabel = null;
    private JLabel errorLabel = null;
    private JPanel jPanel1 = null;
    private JButton closeButton = null;
    private JScrollPane jScrollPane = null;
    private JTextArea jTextArea = null;
    private JTabbedPane jTabbedPane = null;
    private JPanel jPanelInfo = null;
    private JScrollPane jScrollPane2 = null;
    private JList jList = null;
    private JLabel dataLabel = null;
    boolean yesBtnPressed = false;
    private JButton yesButton = null;

    public static void showError(Component component, String string, String string2) {
        ErrorDialog.showError(component, string, string2, null, null);
    }

    public static void showError(Component component, String string, String string2, Object object) {
        ErrorDialog.showError(component, string, string2, object, null);
    }

    public static void showError(Component component, String string, Object object, Throwable throwable) {
        String string2 = throwable.getMessage();
        if (string2 == null || string2.trim().length() == 0) {
            string2 = throwable.toString();
        }
        ErrorDialog.showError(component, string, string2, object, throwable);
    }

    public static void showError(Component component, String string, Throwable throwable) {
        String string2 = throwable.getMessage();
        if (string2 == null || string2.trim().length() == 0) {
            string2 = throwable.toString();
        }
        ErrorDialog.showError(component, string, string2, throwable);
    }

    public static void showError(Component component, String string, String string2, Throwable throwable) {
        ErrorDialog.showError(component, string, string2, null, throwable);
    }

    public static void showError(Component component, String string, String string2, Object object, Throwable throwable) {
        Frame frame = component != null ? JOptionPane.getFrameForComponent(component) : JOptionPane.getRootFrame();
        new ErrorDialog(frame, string, string2, object, throwable, false).show();
    }

    public static boolean showWarning(Component component, String string, String string2) {
        return ErrorDialog.showWarning(component, string, string2, null, null);
    }

    public static boolean showWarning(Component component, String string, String string2, Object object) {
        return ErrorDialog.showWarning(component, string, string2, object, null);
    }

    public static boolean showWarning(Component component, String string, String string2, Throwable throwable) {
        return ErrorDialog.showWarning(component, string, string2, null, throwable);
    }

    public static boolean showWarning(Component component, String string, String string2, Object object, Throwable throwable) {
        Frame frame = component != null ? JOptionPane.getFrameForComponent(component) : JOptionPane.getRootFrame();
        ErrorDialog errorDialog = new ErrorDialog(frame, string, string2, object, throwable, true);
        errorDialog.show();
        return errorDialog.yesBtnPressed;
    }

    static String getErrorDetails(Throwable throwable) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append(new Date()).append(string);
        if (throwable != null) {
            int n;
            stringBuffer.append(string).append("-----------------------------------------------").append(string);
            stringBuffer.append("Exception details.").append(string).append(string);
            stringBuffer.append("Class: ").append(throwable.getClass().getName()).append(string);
            stringBuffer.append("Message: ").append(throwable.getMessage()).append(string);
            stringBuffer.append("Stack trace:").append(string);
            for (object2 = throwable; object2 != null; object2 = ((Throwable)object2).getCause()) {
                if (object2 != throwable) {
                    stringBuffer.append(string).append("Caused by " + object2).append(string).append(string);
                }
                object = ((Throwable)object2).getStackTrace();
                for (int i = 0; i < ((StackTraceElement[])object).length; ++i) {
                    stringBuffer.append(object[i].toString()).append(string);
                }
            }
            if (throwable instanceof SQLException) {
                stringBuffer.append(string);
                for (object = ((SQLException)throwable).getNextException(); object != null; object = ((SQLException)object).getNextException()) {
                    stringBuffer.append(string).append("Next exception: " + object).append(string).append(string);
                    StackTraceElement[] stackTraceElementArray = ((Throwable)object).getStackTrace();
                    for (n = 0; n < stackTraceElementArray.length; ++n) {
                        stringBuffer.append(stackTraceElementArray[n].toString()).append(string);
                    }
                }
            } else if (throwable instanceof InvocationTargetException && (object = ((InvocationTargetException)throwable).getTargetException()) != null) {
                stringBuffer.append(string).append(string).append("Next exception: " + object).append(string).append(string);
                StackTraceElement[] stackTraceElementArray = ((Throwable)object).getStackTrace();
                for (n = 0; n < stackTraceElementArray.length; ++n) {
                    stringBuffer.append(stackTraceElementArray[n].toString()).append(string);
                }
            }
        }
        stringBuffer.append(string).append("-----------------------------------------------").append(string);
        stringBuffer.append("System properties:").append(string).append(string);
        object2 = new TreeMap<Object, Object>(System.getProperties()).entrySet().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            stringBuffer.append(object.getKey()).append("=").append(object.getValue()).append(string);
        }
        stringBuffer.append(string).append("-----------------------------------------------").append(string);
        stringBuffer.append("Runtime info:").append(string).append(string);
        object2 = Runtime.getRuntime();
        stringBuffer.append("Memory TOTAL / FREE / MAX: ").append(((Runtime)object2).totalMemory()).append(" / ").append(((Runtime)object2).freeMemory()).append(" / ").append(((Runtime)object2).maxMemory()).append(string);
        stringBuffer.append("System class loader: ").append("" + ClassLoader.getSystemClassLoader()).append(string);
        stringBuffer.append("Thread context class loader: ").append("" + Thread.currentThread().getContextClassLoader()).append(string);
        stringBuffer.append("Security manager: ").append("" + System.getSecurityManager()).append(string);
        return stringBuffer.toString();
    }

    private ErrorDialog(Frame frame, String string, String string2, Object object, Throwable throwable, boolean bl) {
        super(frame != null ? frame : JOptionPane.getRootFrame());
        this.initialize();
        this.setLocationRelativeTo(this.getOwner());
        this.jTabbedPane.setTitleAt(0, ResourceManager.getMessage("org.java.plugin.boot", "infoTabLabel"));
        this.jTabbedPane.setTitleAt(1, ResourceManager.getMessage("org.java.plugin.boot", "detailsTabLabel"));
        this.setTitle(string);
        this.messageLabel.setText(string2);
        if (throwable != null) {
            this.errorLabel.setText(ResourceManager.getMessage("org.java.plugin.boot", "errorLabel", throwable));
        } else {
            this.errorLabel.setVisible(false);
        }
        if (object instanceof Collection) {
            DefaultListModel defaultListModel = new DefaultListModel();
            Iterator iterator = ((Collection)object).iterator();
            while (iterator.hasNext()) {
                defaultListModel.addElement(iterator.next());
            }
            this.jList.setModel(defaultListModel);
            this.dataLabel.setVisible(false);
        } else if (object instanceof Object[]) {
            DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
            for (int i = 0; i < ((Object[])object).length; ++i) {
                defaultListModel.addElement(((Object[])object)[i]);
            }
            this.jList.setModel(defaultListModel);
            this.dataLabel.setVisible(false);
        } else if (object != null) {
            this.dataLabel.setText(object.toString());
            this.jList.setVisible(false);
        } else {
            this.dataLabel.setVisible(false);
            this.jList.setVisible(false);
        }
        this.jTextArea.setText(ErrorDialog.getErrorDetails(throwable));
        this.jTextArea.setCaretPosition(0);
        this.yesButton.setVisible(bl);
        if (bl) {
            this.closeButton.setText(ResourceManager.getMessage("org.java.plugin.boot", "noLabel"));
            this.yesButton.setText(ResourceManager.getMessage("org.java.plugin.boot", "yesLabel"));
        } else {
            this.closeButton.setText(ResourceManager.getMessage("org.java.plugin.boot", "closeLabel"));
        }
    }

    private void initialize() {
        this.setDefaultCloseOperation(2);
        this.setName("");
        this.setModal(true);
        this.setTitle("An error has occurred");
        this.setSize(467, 279);
        this.setContentPane(this.getJContentPane());
        this.getRootPane().setDefaultButton(this.closeButton);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            BorderLayout borderLayout = new BorderLayout();
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(borderLayout);
            borderLayout.setVgap(2);
            this.jContentPane.add((Component)this.getJPanel1(), "South");
            this.jContentPane.add((Component)this.getJTabbedPane(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.dataLabel = new JLabel();
            this.dataLabel.setText("JLabel");
            this.errorLabel = new JLabel();
            this.messageLabel = new JLabel();
            GridLayout gridLayout = new GridLayout();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(gridLayout);
            gridLayout.setRows(3);
            gridLayout.setColumns(1);
            gridLayout.setVgap(2);
            this.messageLabel.setText("JLabel");
            this.errorLabel.setText("JLabel");
            this.jPanel.add((Component)this.messageLabel, null);
            this.jPanel.add((Component)this.errorLabel, null);
            this.jPanel.add((Component)this.dataLabel, null);
        }
        return this.jPanel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.add((Component)this.getYesButton(), null);
            this.jPanel1.add((Component)this.getCloseButton(), null);
        }
        return this.jPanel1;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
            this.closeButton.setSelected(true);
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ErrorDialog.this.dispose();
                }
            });
        }
        return this.closeButton;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJList());
        }
        return this.jScrollPane;
    }

    private JTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new JTextArea();
            this.jTextArea.setBackground(SystemColor.control);
            this.jTextArea.setEditable(false);
        }
        return this.jTextArea;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.addTab("Info", null, this.getJPanelInfo(), null);
            this.jTabbedPane.addTab("Details", null, this.getJScrollPane2(), null);
        }
        return this.jTabbedPane;
    }

    private JPanel getJPanelInfo() {
        if (this.jPanelInfo == null) {
            this.jPanelInfo = new JPanel();
            this.jPanelInfo.setLayout(new BorderLayout());
            this.jPanelInfo.add((Component)this.getJPanel(), "North");
            this.jPanelInfo.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jPanelInfo;
    }

    private JScrollPane getJScrollPane2() {
        if (this.jScrollPane2 == null) {
            this.jScrollPane2 = new JScrollPane();
            this.jScrollPane2.setViewportView(this.getJTextArea());
        }
        return this.jScrollPane2;
    }

    private JList getJList() {
        if (this.jList == null) {
            this.jList = new JList();
        }
        return this.jList;
    }

    private JButton getYesButton() {
        if (this.yesButton == null) {
            this.yesButton = new JButton();
            this.yesButton.setText("Yes");
            this.yesButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ErrorDialog.this.yesBtnPressed = true;
                    ErrorDialog.this.dispose();
                }
            });
        }
        return this.yesButton;
    }
}

