/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_MainMenu
#define GUARD_MainMenu

#include "GameState.h"
#include "Menu_Base.h"
#include "OptWindow.h"

namespace MainMenu {

class MainMenu_State: public GameState {
public:
	MainMenu_State();
	~MainMenu_State();
	void Main();
	
	void Keyboard(SDL_keysym& keysym);
};

void DrawWorld();

////

class MainSM: public Menu_Base {
public:
	MainSM();

	void CreateHelpWindow();

	bool SwitchOnChoice(Uint16 x, Uint16 y);
};

class MainOptions: public StandardOptions {
public:
	MainOptions(int ix, int iy);
	void Update();	
};

} //end namespace

#endif

